/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.license;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import java.util.Date;

public class ProductLicenseInfo
implements ApplicationLicenseInfo {
    private final ProductLicense license;

    public ProductLicenseInfo(ProductLicense license) {
        this.license = license;
    }

    @Override
    public Date getMaintenanceExpiryDate() {
        return this.license.getMaintenanceExpiryDate();
    }

    @Override
    public boolean isEntitledToSupport() {
        LicenseType licenseType = this.license.getLicenseType();
        if (licenseType == LicenseType.DEMONSTRATION) {
            return false;
        }
        if (licenseType == LicenseType.TESTING) {
            return false;
        }
        if (licenseType == LicenseType.NON_PROFIT) {
            return false;
        }
        return licenseType != LicenseType.PERSONAL;
    }

    @Override
    public boolean isEvaluation() {
        return this.license.isEvaluation();
    }

    @Override
    public boolean isStarter() {
        return this.license.getLicenseType() == LicenseType.STARTER;
    }

    @Override
    public String getSEN() {
        return this.license.getSupportEntitlementNumber();
    }
}

