/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ThreadDumpBundle
extends AbstractApplicationFileBundle {
    private static final Logger log = Logger.getLogger(ThreadDumpBundle.class);
    private final SupportApplicationInfo applicationInfo;
    public static final int MAX_THREAD_DEPTH = Integer.MAX_VALUE;
    private static final DateFormat FILE_NAME_TS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssS");

    public ThreadDumpBundle(BundleManifest bundle, String title, String description, String baseDirectory, SupportApplicationInfo applicationInfo) {
        super(bundle, title, description);
        this.applicationInfo = applicationInfo;
    }

    @Override
    public Map<String, String> getFiles() {
        try {
            return Collections.singletonMap(this.dumpThreadsToLogDir().getAbsolutePath(), "");
        }
        catch (IOException e) {
            log.error((Object)"Failed to generate a thread dump.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dumpThreadsToLogDir() throws IOException {
        String name = "threaddump_" + FILE_NAME_TS_FORMAT.format(new Date()) + "-";
        int count = 0;
        File logDirectory = new File(this.applicationInfo.getApplicationHome(), "logs/support");
        if (!logDirectory.exists()) {
            logDirectory.mkdirs();
        }
        while (new File(logDirectory, name + count + ".log").exists()) {
            ++count;
        }
        File threadDump = new File(logDirectory, name + count + ".log");
        if (!threadDump.createNewFile()) {
            throw new IOException("Failed to create file " + threadDump.getAbsolutePath());
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(threadDump));
            this.getThreadDump(pw, this.applicationInfo);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)pw);
        return threadDump;
    }

    public void getThreadDump(Appendable a, SupportApplicationInfo info) throws IOException {
        a.append(MessageFormat.format("{0} {1} {2} {3}\n Thread dump taken on {4,date,medium} at {4,time,medium}:\n", info.getApplicationName(), info.getApplicationVersion(), info.getApplicationBuildDate(), info.getApplicationBuildNumber(), new Date()));
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            a.append("No thread dump facility available.");
            return;
        }
        ThreadInfo[] threadInfo = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
        if (threadInfo == null || threadInfo.length == 0) {
            a.append("No thread information was generated.");
            return;
        }
        for (ThreadInfo ti : threadInfo) {
            if (ti == null) continue;
            a.append("[").append("" + ti.getThreadId()).append("] ").append(ti.getThreadName()).append(": ").append(ti.getThreadState().toString());
            if (ti.getLockName() != null) {
                a.append(" (waiting on ").append(ti.getLockName().trim());
                if (ti.getLockOwnerId() != -1L) {
                    a.append(" held by ").append("" + ti.getLockOwnerId());
                }
                a.append(")");
            }
            a.append("\n");
            for (StackTraceElement ste : ti.getStackTrace()) {
                a.append("   ").append(ste.toString()).append("\n");
            }
            a.append("\n");
        }
    }

    @Override
    public void validate(ValidationLog validationLog) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean == null) {
            log.warn((Object)"Thread MXBean is not available. No Thread Dump facility available.");
        }
    }
}

