/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CustomisationFileBundle
extends AbstractApplicationFileBundle {
    private static final Logger log = Logger.getLogger(CustomisationFileBundle.class);
    private final TreeMap<String, String> customDecorators;
    private final HashMap<String, String> customHtml;
    private final HashMap<String, String> customStylesheet;
    private final SupportApplicationInfo info;
    private final String LAYOUTS = "layouts";
    private final Map<String, String> customisedFiles = new HashMap<String, String>();

    public CustomisationFileBundle(BundleManifest bundle, String title, String description, SupportApplicationInfo info, TreeMap<String, String> customDecorators, HashMap<String, String> customHtml, HashMap<String, String> customStylesheet) {
        super(bundle, title, description);
        this.customDecorators = customDecorators;
        this.customHtml = customHtml;
        this.customStylesheet = customStylesheet;
        this.info = info;
    }

    @Override
    public Map<String, String> getFiles() {
        File supportDir = new File(this.info.getApplicationHome(), "logs/support");
        if (supportDir.exists() || supportDir.mkdirs()) {
            this.customisedFiles.putAll(this.getCustomLayouts(supportDir));
            this.customisedFiles.putAll(this.getCustomHtml(supportDir));
            this.customisedFiles.putAll(this.getCustomStylesheet(supportDir));
        } else {
            log.error((Object)("Couldn't create export directory " + supportDir.getAbsolutePath()));
        }
        return this.customisedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCustomLayouts(File directory) {
        TreeMap<String, String> tmpCustomLayouts = new TreeMap<String, String>();
        File customisedLayoutsFile = new File(directory, "customLayouts.txt");
        try {
            FileWriter layoutsWriter = new FileWriter(customisedLayoutsFile);
            try {
                StringBuilder customisationsString = new StringBuilder();
                if (this.customDecorators.isEmpty()) {
                    customisationsString.append("No custom layouts");
                }
                for (String file : this.customDecorators.keySet()) {
                    customisationsString.append(file + "\n");
                    try {
                        File vmdFile = new File(directory, file);
                        if (vmdFile.getParentFile().exists() || vmdFile.getParentFile().mkdirs()) {
                            FileWriter vmdWriter = new FileWriter(vmdFile);
                            try {
                                vmdWriter.write(this.customDecorators.get(file));
                            }
                            catch (IOException e) {
                                log.error((Object)("Failed to write vmd to " + vmdFile.getPath() + "."), (Throwable)e);
                            }
                            finally {
                                vmdWriter.flush();
                                vmdWriter.close();
                            }
                            tmpCustomLayouts.put(vmdFile.getAbsolutePath(), "layouts");
                            continue;
                        }
                        log.error((Object)("Couldn't create vmd directory " + vmdFile.getParentFile().getAbsolutePath()));
                    }
                    catch (Exception e) {
                        log.error((Object)"Can't generate vmd file.", (Throwable)e);
                    }
                }
                layoutsWriter.write(customisationsString.toString());
            }
            catch (IOException e) {
                log.error((Object)("Failed to write customisations to " + customisedLayoutsFile.getPath() + "."), (Throwable)e);
            }
            finally {
                layoutsWriter.flush();
                layoutsWriter.close();
            }
            tmpCustomLayouts.put(customisedLayoutsFile.getAbsolutePath(), "layouts");
        }
        catch (Exception e) {
            log.error((Object)"Can't generate customised layouts file.", (Throwable)e);
        }
        return tmpCustomLayouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCustomHtml(File directory) {
        HashMap<String, String> tmpCustomHtml = new HashMap<String, String>();
        try {
            File customisedHtmlFile = new File(directory, "customHtml.txt");
            FileWriter htmlWriter = new FileWriter(customisedHtmlFile);
            try {
                StringBuilder htmlString = new StringBuilder();
                if (this.customHtml.isEmpty()) {
                    htmlString.append("No custom HTML");
                }
                for (String htmlObj : this.customHtml.keySet()) {
                    htmlString.append(htmlObj + "\n" + this.customHtml.get(htmlObj) + "\n\n");
                }
                htmlWriter.write(htmlString.toString());
            }
            catch (IOException e) {
                log.error((Object)("Failed to write customisations to " + customisedHtmlFile.getPath() + "."), (Throwable)e);
            }
            finally {
                htmlWriter.flush();
                htmlWriter.close();
            }
            tmpCustomHtml.put(customisedHtmlFile.getAbsolutePath(), "");
        }
        catch (Exception e) {
            log.error((Object)"Can't generate custom html file.", (Throwable)e);
        }
        return tmpCustomHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getCustomStylesheet(File directory) {
        HashMap<String, String> tmpCustomStylesheet = new HashMap<String, String>();
        try {
            File customStylesheetFile = new File(directory, "customStylesheet.txt");
            FileWriter stylesheetWriter = new FileWriter(customStylesheetFile);
            try {
                StringBuilder stylesheetString = new StringBuilder();
                if (this.customStylesheet.isEmpty()) {
                    stylesheetString.append("No custom stylesheet");
                }
                for (String stylesheetObj : this.customStylesheet.keySet()) {
                    stylesheetString.append(stylesheetObj + "\n" + this.customStylesheet.get(stylesheetObj) + "\n\n");
                }
                stylesheetWriter.write(stylesheetString.toString());
            }
            catch (IOException e) {
                log.error((Object)("Failed to write customisations to " + customStylesheetFile.getPath() + "."), (Throwable)e);
            }
            finally {
                stylesheetWriter.flush();
                stylesheetWriter.close();
            }
            tmpCustomStylesheet.put(customStylesheetFile.getAbsolutePath(), "");
        }
        catch (Exception e) {
            log.error((Object)"Can't generate custom stylesheet file.", (Throwable)e);
        }
        return tmpCustomStylesheet;
    }
}

