/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.RemoteXmlPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.support.tools.properties.MultiValuePropertyStore;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.atlassian.support.tools.salext.bundle.ApplicationPropertiesInfoBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.ThreadDumpBundle;
import com.atlassian.support.tools.salext.output.XmlSupportInfoFormatter;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleReference;

public abstract class AbstractSupportApplicationInfo
implements SupportApplicationInfo {
    protected static final String ENABLED_PLUGINS = "stp.properties.plugins.enabled";
    private boolean isTomcat;
    protected final ApplicationProperties applicationProperties;
    protected final I18nResolver i18nResolver;
    protected final List<ApplicationInfoBundle> applicationInfoBundles = new ArrayList<ApplicationInfoBundle>();
    protected ServletContext servletContext;
    protected final UserManager userManager;
    protected final TemplateRenderer renderer;
    protected final SupportInfoAppenderManager supportInfoAppenderManager;
    protected final SupportInfoXmlKeyResolver supportInfoXmlKeyResolver;
    protected final Map<String, Map<String, String>> propertiesByCategory = new LinkedHashMap<String, Map<String, String>>();
    public static final Map<String, List<Pattern>> FILE_PATTERNS = new HashMap<String, List<Pattern>>();
    private static final Pattern TOMCAT_USERS_SANITIZER_PATTERN = Pattern.compile("(?:.*(?:username|password|name)[ ]*=[ ]*[\"']?([^\"'> ]*)[\"']?.*)", 2);

    public AbstractSupportApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver) {
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.renderer = renderer;
        this.supportInfoAppenderManager = supportInfoAppenderManager;
        this.supportInfoXmlKeyResolver = supportInfoXmlKeyResolver;
        this.applicationInfoBundles.add(new ApplicationPropertiesInfoBundle(BundleManifest.APPLICATION_PROPERTIES, "stp.zip.include.application.properties", "stp.zip.include.application.properties.description", this));
        this.applicationInfoBundles.add(new ThreadDumpBundle(BundleManifest.THREAD_DUMP, "stp.zip.include.threadDump", "stp.zip.include.threadDump.description", null, this));
    }

    protected AbstractSupportApplicationInfo() {
        this.applicationProperties = null;
        this.i18nResolver = null;
        this.userManager = null;
        this.renderer = null;
        this.supportInfoAppenderManager = null;
        this.supportInfoXmlKeyResolver = null;
    }

    @Override
    public String getUserName() {
        try {
            return this.userManager.getRemoteUsername();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getUserEmail() {
        try {
            return this.userManager.getUserProfile(this.getUserName()).getEmail();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public final List<ApplicationInfoBundle> getApplicationFileBundles() {
        return this.applicationInfoBundles;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        this.servletContext = config.getServletContext();
        this.isTomcat = config.getServletContext().getServerInfo().contains("Tomcat");
    }

    @Override
    public PropertyStore loadProperties() {
        MultiValuePropertyStore store = new MultiValuePropertyStore();
        this.supportInfoAppenderManager.addSupportInfo(store);
        return store;
    }

    @Override
    public boolean isTomcat() {
        return this.isTomcat;
    }

    protected SisyphusPatternSource getPatternSourceByURL(String urlString, Proxy proxy) throws IOException, ClassNotFoundException {
        return new RemoteXmlPatternSource(new URL(urlString), proxy);
    }

    public String findTomcatFileOrDirectory(String fileOrDirectoryName) {
        String catalinaBase = System.getProperty("catalina.base");
        File file = new File(catalinaBase, fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String catalinaHome = System.getProperty("catalina.home");
        file = new File(catalinaHome, fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String workingDirectory = System.getProperty("working.dir");
        file = new File(workingDirectory + "../", fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public String getApplicationName() {
        return this.applicationProperties.getDisplayName();
    }

    @Override
    public String getApplicationVersion() {
        return this.applicationProperties.getVersion();
    }

    @Override
    public String getApplicationBuildNumber() {
        return this.applicationProperties.getBuildNumber();
    }

    @Override
    public Date getApplicationBuildDate() {
        return this.applicationProperties.getBuildDate();
    }

    @Override
    public String getApplicationHome() {
        return this.applicationProperties.getHomeDirectory().toString();
    }

    @Override
    public String getText(String key) {
        return this.i18nResolver.getText(key);
    }

    @Override
    public String getText(String key, Serializable ... arguments) {
        return this.i18nResolver.getText(key, arguments);
    }

    @Override
    public String getServletContextPath(String pathToLookup) {
        return this.servletContext.getRealPath(pathToLookup);
    }

    @Override
    public void flagSelectedApplicationFileBundles(HttpServletRequest req) {
        List<ApplicationInfoBundle> selectedApplicationFileBundles = this.getSelectedApplicationInfoBundles(req);
        for (ApplicationInfoBundle bundle : this.applicationInfoBundles) {
            if (selectedApplicationFileBundles != null && selectedApplicationFileBundles.size() > 0) {
                if (selectedApplicationFileBundles.contains(bundle)) continue;
                bundle.setSelected(false);
                continue;
            }
            bundle.setSelected(true);
        }
    }

    @Override
    public List<ApplicationInfoBundle> getSelectedApplicationInfoBundles(HttpServletRequest req) {
        ArrayList<ApplicationInfoBundle> selectedApplicationInfoBundles = new ArrayList<ApplicationInfoBundle>();
        for (ApplicationInfoBundle applicationInfoBundle : this.applicationInfoBundles) {
            String flagValue = req.getParameter(applicationInfoBundle.getKey());
            if (flagValue == null || !Boolean.parseBoolean(flagValue)) continue;
            selectedApplicationInfoBundles.add(applicationInfoBundle);
        }
        return selectedApplicationInfoBundles;
    }

    @Override
    public Map<String, String> getPropertiesByCategory(String category) {
        return this.propertiesByCategory.get(category);
    }

    @Override
    public Set<String> getPropertyCategories() {
        return this.propertiesByCategory.keySet();
    }

    @Override
    public String saveProperties() {
        PropertyStore supportInfoProperties = this.loadProperties();
        Properties xmlElementNameMappings = this.supportInfoXmlKeyResolver.getKeyMappings();
        return XmlSupportInfoFormatter.getFormattedProperties(supportInfoProperties, xmlElementNameMappings, this.getStpVersion(), this.getApplicationName(), this.getApplicationVersion(), this.getApplicationSEN(), this.getApplicationServerID());
    }

    private String getStpVersion() {
        return ((BundleReference)this.getClass().getClassLoader()).getBundle().getVersion().toString();
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.renderer;
    }

    @Override
    public String getBaseURL(HttpServletRequest req) {
        return req.getRequestURI().replaceFirst(req.getServletPath() + ".*", "");
    }

    @Override
    public List<String> getSystemWarnings() {
        return Collections.emptyList();
    }

    public String getAppServer() {
        switch (Container.get()) {
            case 1: {
                return "Apache Tomcat";
            }
            case 3: {
                return "Orion";
            }
            case 4: {
                return "IBM WebLogic";
            }
            case 6: {
                return "JRUN";
            }
            case 2: {
                return "RESIN" + Container.get();
            }
            case 5: {
                return "HPAS";
            }
            case 0: {
                return "Unknown";
            }
        }
        return "Unknown";
    }

    @Override
    public String getExportDirectory() {
        return this.getApplicationHome() + "/export";
    }

    @Override
    public String getFromAddress() {
        return "noreply@atlassian.com";
    }

    protected Proxy getProxy() {
        String proxy = System.getProperty("http.proxyHost");
        if (StringUtils.isNotEmpty((String)proxy)) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, (int)Integer.getInteger("http.proxyPort", 80)));
        }
        proxy = System.getProperty("https.proxyHost");
        if (StringUtils.isNotEmpty((String)proxy)) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, (int)Integer.getInteger("https.proxyPort", 443)));
        }
        return Proxy.NO_PROXY;
    }

    static {
        FILE_PATTERNS.put("server.xml", Arrays.asList(Pattern.compile("(?:.*(?:username|password|keystorePass|truststorePass|connectionPassword|connectionName)[ ]*=[ ]*[\"']?([^\"'> ]*)[\"']?.*)", 2)));
        FILE_PATTERNS.put("crowd.properties", Arrays.asList(Pattern.compile("application\\.(?:name|password)\\s+(.+)\\s*", 2)));
        FILE_PATTERNS.put("tomcat-users.xml", Arrays.asList(TOMCAT_USERS_SANITIZER_PATTERN));
        FILE_PATTERNS.put("atlassian-user.xml", Arrays.asList(Pattern.compile("(?:securityPrincipal\\s*>)(.*)(?:</\\s*securityPrincipal)"), Pattern.compile("(?:securityCredential\\s*>)(.*)(?:</\\s*securityCredential)")));
    }
}

