/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.rest;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.tools.rest.LicenseStatus;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Produces(value={"application/json"})
@Path(value="license")
public class LicenseStatusService {
    private static final int DAY_IN_MS = 86400000;
    private final UserManager userManager;
    private final PluginSettings pluginSettings;
    private final SupportApplicationInfo appInfo;
    private static final String BANNER_HIDDEN_TILL_DAY = "bannerHiddenTillDay";

    public LicenseStatusService(UserManager userManager, PluginSettingsFactory pluginSettingsFactory, SupportApplicationInfo appInfo) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.userManager = userManager;
        this.appInfo = appInfo;
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response status() {
        String remoteUsername = this.userManager.getRemoteUsername();
        if (StringUtils.isBlank((String)remoteUsername)) {
            return Response.status((int)401).cacheControl(LicenseStatusService.never()).build();
        }
        if (!this.userManager.isAdmin(remoteUsername)) {
            return Response.status((int)403).cacheControl(LicenseStatusService.never()).build();
        }
        ApplicationLicenseInfo licenseInfo = this.appInfo.getLicenseInfo();
        if (licenseInfo.isEvaluation()) {
            return Response.status((int)204).build();
        }
        int daysToExpiry = this.getDaysToExpiry(licenseInfo.getMaintenanceExpiryDate());
        if (daysToExpiry > 30 || daysToExpiry < 0) {
            this.resetBannerHiddenProperty(remoteUsername);
            return Response.status((int)204).build();
        }
        int hiddenTillDays = this.getBannerHiddenTillDays(remoteUsername);
        if (this.shouldKeepBannerHiddenBanner(hiddenTillDays, daysToExpiry)) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)new LicenseStatus(this.appInfo.getApplicationName(), this.appInfo.getApplicationSEN(), daysToExpiry)).build();
    }

    @POST
    @Path(value="/remindMeLater")
    public Response remindMeLater() {
        String remoteUsername = this.userManager.getRemoteUsername();
        if (StringUtils.isBlank((String)remoteUsername) || !this.userManager.isAdmin(remoteUsername)) {
            return Response.status((int)401).cacheControl(LicenseStatusService.never()).build();
        }
        int daysToExpiry = this.getDaysToExpiry(this.appInfo.getLicenseInfo().getMaintenanceExpiryDate());
        if (daysToExpiry > 30 || daysToExpiry < 0) {
            this.resetBannerHiddenProperty(remoteUsername);
        } else {
            int hiddenTillDays = daysToExpiry / 2;
            hiddenTillDays = hiddenTillDays > 7 ? 15 : (hiddenTillDays > 0 ? 7 : 0);
            this.pluginSettings.put(this.getUserSettingKey(remoteUsername), (Object)Integer.valueOf(hiddenTillDays).toString());
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/remindMeNever")
    public Response remindMeN() {
        String remoteUsername = this.userManager.getRemoteUsername();
        if (StringUtils.isBlank((String)remoteUsername) || !this.userManager.isAdmin(remoteUsername)) {
            return Response.status((int)401).cacheControl(LicenseStatusService.never()).build();
        }
        int daysToExpiry = this.getDaysToExpiry(this.appInfo.getLicenseInfo().getMaintenanceExpiryDate());
        if (daysToExpiry > 30 || daysToExpiry < 0) {
            this.resetBannerHiddenProperty(remoteUsername);
        } else {
            this.pluginSettings.put(this.getUserSettingKey(remoteUsername), (Object)"-1");
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/clearReminders")
    public Response clearReminders() {
        String remoteUsername = this.userManager.getRemoteUsername();
        if (StringUtils.isBlank((String)remoteUsername) || !this.userManager.isAdmin(remoteUsername)) {
            return Response.status((int)401).cacheControl(LicenseStatusService.never()).build();
        }
        this.resetBannerHiddenProperty(remoteUsername);
        return Response.ok().build();
    }

    private boolean shouldKeepBannerHiddenBanner(int hiddenTillDays, int daysToExpiry) {
        if (hiddenTillDays == -1) {
            return true;
        }
        if (hiddenTillDays == 0) {
            return daysToExpiry < 7;
        }
        return daysToExpiry > hiddenTillDays;
    }

    private void resetBannerHiddenProperty(String username) {
        this.pluginSettings.remove(this.getUserSettingKey(username));
    }

    private int getBannerHiddenTillDays(String username) {
        String settingValue = (String)this.pluginSettings.get(this.getUserSettingKey(username));
        if (StringUtils.isBlank((String)settingValue)) {
            return 30;
        }
        try {
            return Integer.parseInt(settingValue);
        }
        catch (NumberFormatException e) {
            return 30;
        }
    }

    private int getDaysToExpiry(Date expiryDate) {
        int daysToExpiry = 365;
        if (expiryDate != null) {
            daysToExpiry = (int)((expiryDate.getTime() - System.currentTimeMillis()) / 86400000L);
        }
        return daysToExpiry;
    }

    private static CacheControl never() {
        CacheControl cacheNever = new CacheControl();
        cacheNever.setNoStore(true);
        cacheNever.setNoCache(true);
        return cacheNever;
    }

    private String getUserSettingKey(String username) {
        return BANNER_HIDDEN_TILL_DAY + username;
    }
}

