package com.atlassian.database.console.spring;

import com.atlassian.database.console.connection.context.AchooExecutor;
import com.atlassian.database.console.connection.context.BambooAchooExecutor;
import com.atlassian.database.console.connection.context.ConfluenceAchooExecutor;
import com.atlassian.database.console.connection.context.CrowdAchooExecutor;
import com.atlassian.database.console.connection.provider.AchooConnectionProvider;
import com.atlassian.database.console.connection.provider.ConfluenceConnectionProvider;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.FecruOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import static com.atlassian.plugins.osgi.javaconfig.OsgiServices.importOsgiService;
import static java.lang.Class.forName;

@Configuration
public class SpringConfig {
    // ---------- IMPORTED SERVICES --------------

    @Bean
    public ApplicationProperties applicationProperties() {
        return importOsgiService(ApplicationProperties.class);
    }

    @Bean
    public TransactionalExecutorFactory transactionalExecutorFactory() {
        return importOsgiService(TransactionalExecutorFactory.class);
    }

    @Bean
    public TransactionTemplate transactionTemplate() {
        return importOsgiService(TransactionTemplate.class);
    }

    @Bean
    public UserManager userManager() {
        return importOsgiService(UserManager.class);
    }

    // ---------- INTERNAL SERVICES --------------

    @Bean("achooExecutor")
    @Conditional(BambooOnly.class)
    public AchooExecutor bambooAchooExecutor(final TransactionTemplate transactionTemplate) {
        return new BambooAchooExecutor(transactionTemplate);
    }

    /**
     * Exists so the servlet can start with BB, and we can serve a warning
     */
    @Bean("achooExecutor")
    @Conditional(BitbucketOnly.class)
    public AchooExecutor bitbucketAchooExecutor() {
        return runnable -> {
        };
    }

    @Bean("achooExecutor")
    @Conditional(ConfluenceOnly.class)
    public AchooExecutor confluenceAchooExecutor(
            final TransactionalExecutorFactory transactionalExecutorFactory,
            final TransactionTemplate transactionTemplate
    ) {
        final TransactionalExecutor transactionalExecutor = transactionalExecutorFactory.create();
        return new ConfluenceAchooExecutor(transactionalExecutor, transactionTemplate);
    }

    @Bean("achooExecutor")
    @Conditional(CrowdOnly.class)
    public AchooExecutor crowdAchooExecutor() {
        return new CrowdAchooExecutor();
    }

    /**
     * Exists so the servlet can start with FeCru, and we can serve a warning
     */
    @Bean("achooExecutor")
    @Conditional(FecruOnly.class)
    public AchooExecutor feCruAchooExecutor() {
        return runnable -> {
        };
    }

    @Bean("achooExecutor")
    @Conditional(JiraOnly.class)
    public AchooExecutor jiraAchooExecutor() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        final Class<?> databaseAccessorClass = forName("com.atlassian.jira.database.DatabaseAccessor");
        final Object databaseAccessorObject = importOsgiService(databaseAccessorClass);
        final Class<?> jiraAchooExecutorClass = forName("com.atlassian.database.console.connection.context.JiraAchooExecutor");
        final Constructor<?> constructor = jiraAchooExecutorClass.getDeclaredConstructor(databaseAccessorClass);
        return (AchooExecutor) constructor.newInstance(databaseAccessorObject);
    }

    @Bean("achooExecutor")
    @Conditional(RefappOnly.class)
    public AchooExecutor refappAchooExecutor() {
        return Runnable::run;
    }

    @Bean("achooConnectionProvider")
    @Conditional(BambooOnly.class)
    public AchooConnectionProvider bambooAchooConnectionProvider() throws Exception {
        final Class<?> pluginHibernateSessionFactoryClass = forName("com.atlassian.bamboo.persistence3.PluginHibernateSessionFactory");
        final Object pluginHibernateSessionFactoryObject = importOsgiService(pluginHibernateSessionFactoryClass);
        final Class<?> achooConnectionProviderClass = forName("com.atlassian.database.console.connection.provider.BambooConnectionProvider");
        final Constructor<?> constructor = achooConnectionProviderClass.getDeclaredConstructor(pluginHibernateSessionFactoryClass);
        return (AchooConnectionProvider) constructor.newInstance(pluginHibernateSessionFactoryObject);
    }

    /**
     * Exists so the servlet can start with BB, and we can serve a warning
     */
    @Bean("achooConnectionProvider")
    @Conditional(BitbucketOnly.class)
    public AchooConnectionProvider bitbucketAchooConnectionProvider() {
        return () -> null;
    }

    @Bean("achooConnectionProvider")
    @Conditional(ConfluenceOnly.class)
    public AchooConnectionProvider confluenceAchooConnectionProvider() {
        return new ConfluenceConnectionProvider();
    }

    @Bean("achooConnectionProvider")
    @Conditional(CrowdOnly.class)
    public AchooConnectionProvider crowdConnectionProvider() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        final Class<?> tenantAwareDataSourceProviderClass = forName("com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider");
        final Object tenantAwareDataSourceProviderObject = importOsgiService(tenantAwareDataSourceProviderClass);
        final Class<?> achooConnectionProviderClass = forName("com.atlassian.database.console.connection.provider.CrowdConnectionProvider");
        final Constructor<?> constructor = achooConnectionProviderClass.getDeclaredConstructor(tenantAwareDataSourceProviderClass);
        return (AchooConnectionProvider) constructor.newInstance(tenantAwareDataSourceProviderObject);
    }

    /**
     * Exists so the servlet can start with FeCru, and we can serve a warning
     */
    @Bean("achooConnectionProvider")
    @Conditional(FecruOnly.class)
    public AchooConnectionProvider feCruAchooConnectionProvider() {
        return () -> null;
    }

    @Bean("achooConnectionProvider")
    @Conditional(JiraOnly.class)
    public AchooConnectionProvider jiraConnectionProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        final Class<?> achooConnectionProviderClass = forName("com.atlassian.database.console.connection.provider.JiraConnectionProvider");
        return (AchooConnectionProvider) achooConnectionProviderClass.newInstance();
    }

    @Bean("achooConnectionProvider")
    @Conditional(RefappOnly.class)
    public AchooConnectionProvider refappAchooConnectionProvider() throws Exception {
        final Class<?> refAppconnectionProviderClass = forName("com.atlassian.refapp.api.ConnectionProvider");
        final Object connectionProviderObject = importOsgiService(refAppconnectionProviderClass);
        final Class<?> achooConnectionProviderClass = forName("com.atlassian.database.console.connection.provider.RefAppConnectionProvider");
        final Constructor<?> constructor = achooConnectionProviderClass.getDeclaredConstructor(refAppconnectionProviderClass);
        return (AchooConnectionProvider) constructor.newInstance(connectionProviderObject);
    }
}
