/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xwork.interceptors;

import com.atlassian.xwork.ParameterSafe;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.opensymphony.xwork2.interceptor.ParametersInterceptor;
import com.opensymphony.xwork2.util.ValueStack;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.struts2.dispatcher.HttpParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeParametersInterceptor
extends ParametersInterceptor {
    public static final Logger log = LoggerFactory.getLogger(SafeParametersInterceptor.class);
    public static final String PARAMETER_NAME_BLOCKED = "Parameter name blocked: ";
    private static final Pattern EXCLUDE_CLASS_PATTERN = Pattern.compile(".*class[^a-z0-9_].*", 2);
    private static final Pattern SAFE_PARAMETER_NAME_PATTERN = Pattern.compile("\\w+((\\.\\w+)|(\\[\\d+\\])|(\\['[\\w.]*'\\]))*");
    private static final Set<String> BLOCKED_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("actionErrors", "actionMessages"));
    private static final Pattern MAP_PARAMETER_PATTERN = Pattern.compile(".*\\['[a-zA-Z0-9_]+'\\]");
    private boolean disableAnnotationChecks = false;

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    public void setDisableAnnotationChecks(boolean disableAnnotationChecks) {
        this.disableAnnotationChecks = disableAnnotationChecks;
    }

    public String doIntercept(ActionInvocation invocation) throws Exception {
        this.before(invocation);
        return super.doIntercept(invocation);
    }

    protected boolean shouldNotIntercept(ActionInvocation actionInvocation) {
        return actionInvocation.getAction() instanceof NoParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before(ActionInvocation invocation) throws Exception {
        if (this.shouldNotIntercept(invocation)) {
            return;
        }
        Action action = (Action)invocation.getAction();
        Map<String, Object> parameters = this.filterSafeParameters(this.retrieveParameters(invocation.getInvocationContext()), action);
        if (log.isDebugEnabled()) {
            log.debug("Setting params " + parameters);
        }
        ActionContext invocationContext = invocation.getInvocationContext();
        try {
            invocationContext.put("xwork.NullHandler.createNullObjects", (Object)Boolean.TRUE);
            invocationContext.put("xwork.MethodAccessor.denyMethodExecution", (Object)Boolean.TRUE);
            invocationContext.put("report.conversion.errors", (Object)Boolean.TRUE);
            if (parameters != null) {
                ValueStack stack = ActionContext.getContext().getValueStack();
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    Long number;
                    String name = entry.getKey();
                    if (SafeParametersInterceptor.isNumeric(name) && (number = Long.valueOf(Long.parseLong(name))) > Integer.MAX_VALUE) {
                        name = name + 'L';
                    }
                    stack.setValue(name, entry.getValue());
                }
            }
        }
        finally {
            invocationContext.put("xwork.NullHandler.createNullObjects", (Object)Boolean.FALSE);
            invocationContext.put("xwork.MethodAccessor.denyMethodExecution", (Object)Boolean.FALSE);
            invocationContext.put("report.conversion.errors", (Object)Boolean.FALSE);
        }
    }

    private Map<String, Object> filterSafeParameters(HttpParameters parameters, Action action) {
        HashMap<String, Object> safeParameters = new HashMap<String, Object>();
        parameters.entrySet().stream().filter(entry -> SafeParametersInterceptor.isSafeParameterName((String)entry.getKey(), action, this.disableAnnotationChecks)).forEach(entry -> safeParameters.put((String)entry.getKey(), entry.getValue()));
        return safeParameters;
    }

    static boolean isSafeParameterName(String key, Action action) {
        return SafeParametersInterceptor.isSafeParameterName(key, action, true);
    }

    static boolean isSafeParameterName(String key, Action action, boolean disableAnnotationChecks) {
        if (BLOCKED_PARAMETER_NAMES.contains(key)) {
            return false;
        }
        if (EXCLUDE_CLASS_PATTERN.matcher(key).matches()) {
            log.info(PARAMETER_NAME_BLOCKED + key);
            return false;
        }
        if (!SAFE_PARAMETER_NAME_PATTERN.matcher(key).matches()) {
            return false;
        }
        if (!disableAnnotationChecks && (key.contains(".") || MAP_PARAMETER_PATTERN.matcher(key).matches())) {
            return SafeParametersInterceptor.isSafeComplexParameterName(key, action);
        }
        return true;
    }

    private static boolean isSafeComplexParameterName(String key, Action action) {
        try {
            PropertyDescriptor[] descs;
            String initialParameterName = SafeParametersInterceptor.extractInitialParameterName(key);
            BeanInfo info = Introspector.getBeanInfo(action.getClass());
            for (PropertyDescriptor desc : descs = info.getPropertyDescriptors()) {
                if (!desc.getName().equals(initialParameterName)) continue;
                if (SafeParametersInterceptor.isSafeMethod(desc.getReadMethod())) {
                    return true;
                }
                log.info("Attempt to call unsafe property setter " + key + " on " + action);
                return false;
            }
        }
        catch (IntrospectionException e) {
            log.warn("Error introspecting action parameter " + key + " for action " + action + ": " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static String extractInitialParameterName(String key) {
        if (!key.contains("[") || key.indexOf(".") > 0 && key.indexOf("[") > key.indexOf(".")) {
            return key.substring(0, key.indexOf("."));
        }
        return key.substring(0, key.indexOf("["));
    }

    private static boolean isSafeMethod(Method writeMethod) {
        boolean isAnnotationTrue = false;
        boolean isReturnTypeTrue = false;
        if (writeMethod != null) {
            boolean bl = isAnnotationTrue = writeMethod.getAnnotation(ParameterSafe.class) != null;
        }
        if (writeMethod.getReturnType() != null) {
            isReturnTypeTrue = writeMethod.getReturnType().getAnnotation(ParameterSafe.class) != null;
        }
        return isAnnotationTrue || isReturnTypeTrue;
    }

    private static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

