/**
 *
 */
package com.atlassian.xwork.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.RegexFieldValidator;

import java.util.Arrays;

/**
 * Validate that a field contains comma separated e-mail addresses.
 *
 * @author Paul Curren
 */
public class CommaSeparatedEmailValidator extends RegexFieldValidator {

    private static final String COMMA_SEPARATED_EMAIL_PATTERN = "\\b^(['_a-z0-9-\\+]+(\\.['_a-z0-9-\\+]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*\\.([a-z]{2,6}))(,\\s*['_a-z0-9-\\+]+(\\.['_a-z0-9-\\+]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*\\.([a-z]{2,6}))*$\\b";

    public CommaSeparatedEmailValidator() {
        setRegex(COMMA_SEPARATED_EMAIL_PATTERN);
        setCaseSensitive(false);
    }

    public void validate1(Object object) throws ValidationException {
        String fieldName = getFieldName();
        String value = (String) getFieldValue(fieldName, object);

        if (value == null) {
            return;
        }

        value = value.trim();

        if (value.length() == 0) {
            return;
        }

        String[] emails = value.split("\\s*,\\s*"); // split on comma surrounded by option whitespace

        Arrays.stream(emails).forEach(email -> {
            validateFieldValue(object, email, getRegex());
        });
    }
}
