package com.atlassian.xwork.interceptors;

import com.atlassian.util.profiling.ProfilingUtils;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.Interceptor;
import org.apache.struts2.ServletActionContext;

public class XWorkProfilingInterceptor implements Interceptor {
    String location;

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        before(invocation);
        String result = invocation.invoke();
        after(invocation, result);

        return result;
    }

    private void before(ActionInvocation actionInvocation) throws Exception {
        UtilTimerStack.push(makeStackKey(actionInvocation.getProxy()));
        ServletActionContext.getRequest(); // needed to make sure the request is present (I think)
    }

    private void after(ActionInvocation actionInvocation, String string) throws Exception {
        UtilTimerStack.pop(makeStackKey(actionInvocation.getProxy()));
    }

    private String makeStackKey(ActionProxy proxy) {
        String methodName = proxy.getConfig().getMethodName();

        if (methodName == null)
            methodName = "execute";

        String actionClazz = ProfilingUtils.getJustClassName(proxy.getConfig().getClassName());

        return "XW Interceptor: " + (location != null ? location + ": " : "") + proxy.getNamespace() + "/" + proxy.getActionName() + ".action (" + actionClazz + "." + methodName + "())";
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public void destroy() {

    }

    @Override
    public void init() {

    }
}
