/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.confluence;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.streams.spi.Evictor;
import com.google.common.base.Preconditions;
import net.sf.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceEvictor
implements Evictor<ConfluenceEntityObject> {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceEvictor.class);
    private final PluginHibernateSessionFactory sessionFactory;

    public ConfluenceEvictor(PluginHibernateSessionFactory sessionFactory) {
        this.sessionFactory = (PluginHibernateSessionFactory)Preconditions.checkNotNull((Object)sessionFactory, (Object)"sessionFactory");
    }

    public Void apply(ConfluenceEntityObject entity) {
        if (!(entity instanceof AbstractPage)) {
            return null;
        }
        try {
            this.sessionFactory.getSession().evict((Object)entity);
        }
        catch (HibernateException e) {
            log.warn("Failed to evict the entity from the session", (Throwable)e);
        }
        return null;
    }
}

