/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.testing.builder;

import com.atlassian.streams.api.StreamsFilterType;
import com.atlassian.streams.api.builder.StreamsFeedUriBuilder;
import com.atlassian.streams.api.common.Pair;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class ActivityStreamsTestUriBuilder
implements StreamsFeedUriBuilder {
    private final String baseUrl;
    private final Multimap<String, String> parameters = ArrayListMultimap.create();
    private final Set<String> providers = Sets.newHashSet();
    private Integer maxResults;
    private Integer timeout;

    public ActivityStreamsTestUriBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private URI buildUri(String path) {
        StringBuilder url = new StringBuilder(this.baseUrl);
        url.append(path);
        String sep = "?";
        for (Map.Entry propEntry : this.parameters.entries()) {
            url.append(sep).append(ActivityStreamsTestUriBuilder.encode((String)propEntry.getKey())).append("=").append(ActivityStreamsTestUriBuilder.encode((String)propEntry.getValue()));
            sep = "&";
        }
        if (!this.providers.isEmpty()) {
            url.append(sep).append("providers").append('=').append(ActivityStreamsTestUriBuilder.encode(Joiner.on((char)' ').join(this.providers)));
        }
        if (this.maxResults != null) {
            url.append(sep).append("maxResults").append("=").append(this.maxResults);
        }
        if (this.timeout != null) {
            url.append(sep).append("timeout").append("=").append(this.timeout);
        }
        return URI.create(url.toString()).normalize();
    }

    public URI getUri() {
        return this.buildUri("/activity");
    }

    public URI getServletUri() {
        return this.buildUri("/plugins/servlet/streams");
    }

    public StreamsFeedUriBuilder setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public StreamsFeedUriBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public StreamsFeedUriBuilder addApplication(String name) {
        this.parameters.put((Object)"application", (Object)name);
        return this;
    }

    public StreamsFeedUriBuilder addLocalOnly(boolean localOnly) {
        this.parameters.put((Object)"local", (Object)Boolean.toString(localOnly));
        return this;
    }

    public StreamsFeedUriBuilder addProviderFilter(String providerKey, String filterKey, Pair<StreamsFilterType.Operator, Iterable<String>> filter) {
        this.parameters.put((Object)providerKey, (Object)this.toString(filterKey, filter));
        return this;
    }

    public StreamsFeedUriBuilder addAuthOnly(boolean authOnly) {
        this.parameters.put((Object)"authOnly", (Object)Boolean.toString(authOnly));
        return this;
    }

    public StreamsFeedUriBuilder addStandardFilter(String filterKey, StreamsFilterType.Operator op, String value) {
        return this.addStandardFilter(filterKey, (Pair<StreamsFilterType.Operator, Iterable<String>>)Pair.pair((Object)op, (Object)ImmutableList.of((Object)value)));
    }

    public StreamsFeedUriBuilder addStandardFilter(String filterKey, StreamsFilterType.Operator op, Date date) {
        return this.addStandardFilter(filterKey, (Pair<StreamsFilterType.Operator, Iterable<String>>)Pair.pair((Object)op, (Object)ImmutableList.of((Object)Long.toString(date.getTime()))));
    }

    public StreamsFeedUriBuilder addStandardFilter(String filterKey, StreamsFilterType.Operator op, Iterable<String> values) {
        return this.addStandardFilter(filterKey, (Pair<StreamsFilterType.Operator, Iterable<String>>)Pair.pair((Object)op, values));
    }

    public StreamsFeedUriBuilder addStandardFilter(String filterKey, Pair<StreamsFilterType.Operator, Iterable<String>> filter) {
        this.parameters.put((Object)"streams", (Object)this.toString(filterKey, filter));
        return this;
    }

    private String toString(String filterKey, Pair<StreamsFilterType.Operator, Iterable<String>> filter) {
        return filterKey + " " + filter.first() + " " + Joiner.on((char)' ').join((Iterable)filter.second());
    }

    public StreamsFeedUriBuilder addLegacyFilterUser(String filterUser) {
        this.parameters.put((Object)"filterUser", (Object)filterUser);
        return this;
    }

    public StreamsFeedUriBuilder addLegacyKey(String key) {
        this.parameters.put((Object)"key", (Object)key);
        return this;
    }

    public StreamsFeedUriBuilder setLegacyMaxDate(long maxDate) {
        this.parameters.put((Object)"maxDate", (Object)Long.toString(maxDate));
        return this;
    }

    public StreamsFeedUriBuilder addAuthenticationParameterIfLoggedIn() {
        throw new UnsupportedOperationException("Don't use in tests");
    }

    public StreamsFeedUriBuilder addOSUserAuthenticationParameter() {
        this.parameters.put((Object)"os_authType", (Object)"basic");
        return this;
    }

    public StreamsFeedUriBuilder setLegacyMinDate(long minDate) {
        this.parameters.put((Object)"minDate", (Object)Long.toString(minDate));
        return this;
    }

    public StreamsFeedUriBuilder addProvider(String key) {
        this.providers.add(key);
        return this;
    }

    public StreamsFeedUriBuilder addUseAcceptLang(boolean useAcceptLang) {
        this.parameters.put((Object)"use-accept-lang", (Object)Boolean.toString(useAcceptLang));
        return this;
    }

    private static String encode(String uriComponent) {
        try {
            return URLEncoder.encode(uriComponent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This can't happen", e);
        }
    }
}

