/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.api.common.uri;

import com.atlassian.streams.api.common.Pair;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;

public final class Uris {
    private Uris() {
        throw new RuntimeException("UriEncoder cannot be instantiated");
    }

    public static Function<String, String> encode() {
        return Encode.INSTANCE;
    }

    public static String encode(String uriComponent) {
        return (String)Uris.encode().apply((Object)uriComponent);
    }

    public static String encode(String uriComponent, String encoding) {
        try {
            return URLEncoder.encode(uriComponent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decode(String uriComponent) {
        try {
            return URLDecoder.decode(uriComponent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Funny JVM you have here", e);
        }
    }

    public static String decode(String uriComponent, String encoding) {
        try {
            return URLDecoder.decode(uriComponent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Multimap<String, String> getQueryParameters(URI uri) {
        if (uri.getQuery() == null) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Pair param : Iterables.transform(Arrays.asList(uri.getQuery().split("&")), Uris.asQueryParam())) {
            builder.put(param.first(), param.second());
        }
        return builder.build();
    }

    private static Function<String, Pair<String, String>> asQueryParam() {
        return AsQueryParam.INSTANCE;
    }

    private static enum AsQueryParam implements Function<String, Pair<String, String>>
    {
        INSTANCE;


        public Pair<String, String> apply(String p) {
            String[] nameValue = p.split("=");
            String name = Uris.decode(nameValue[0]);
            String value = nameValue.length == 2 ? Uris.decode(nameValue[1]) : "";
            return Pair.pair(name, value);
        }
    }

    private static enum Encode implements Function<String, String>
    {
        INSTANCE;


        public String apply(String s) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Funny JVM you have here", e);
            }
        }
    }
}

