/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.rest.resources;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.streams.internal.ProjectKeyValidator;
import com.atlassian.streams.internal.rest.representations.ValidationErrorCollectionRepresentation;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

@Path(value="/validate")
@AnonymousAllowed
public class StreamsValidationResource {
    private static final CacheControl NO_CACHE = new CacheControl();
    private static final String PREF_TITLE = "title";
    private static final String PREF_KEYS = "keys";
    private static final String PREF_USERNAME = "username";
    private static final String PREF_NUMOFENTRIES = "numofentries";
    private final ProjectKeyValidator validator;
    private final UserManager userManager;
    private final Predicate<String> validUsername = new Predicate<String>(){

        public boolean apply(String username) {
            return StreamsValidationResource.this.isValidUsername(username);
        }
    };

    public StreamsValidationResource(ProjectKeyValidator validator, UserManager userManager) {
        this.validator = (ProjectKeyValidator)Preconditions.checkNotNull((Object)validator, (Object)"validator");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
    }

    @GET
    @Produces(value={"application/vnd.atl.streams+json"})
    public Response validate(@QueryParam(value="title") String title, @QueryParam(value="keys") String keys, @QueryParam(value="username") String usernames, @QueryParam(value="numofentries") String numOfEntriesString, @QueryParam(value="local") boolean local) {
        Collection invalidUsernames;
        ImmutableList.Builder errorBuilder = ImmutableList.builder();
        if (StringUtils.isBlank((String)title)) {
            errorBuilder.add((Object)new ValidationErrorCollectionRepresentation.ValidationErrorEntry(PREF_TITLE, "gadget.activity.stream.error.pref.title"));
        }
        if (StringUtils.isNotBlank((String)keys) && !keys.contains("__all_projects__") && this.hasInvalidKey(keys, local)) {
            errorBuilder.add((Object)new ValidationErrorCollectionRepresentation.ValidationErrorEntry(PREF_KEYS, "gadget.activity.stream.error.pref.keys"));
        }
        if (StringUtils.isNotEmpty((String)usernames) && !Iterables.isEmpty((Iterable)(invalidUsernames = Collections2.filter(Arrays.asList(usernames.split(",")), (Predicate)Predicates.not(this.validUsername))))) {
            errorBuilder.add((Object)new ValidationErrorCollectionRepresentation.ValidationErrorEntry(PREF_USERNAME, "gadget.activity.stream.error.pref.username", invalidUsernames));
        }
        if (StringUtils.isBlank((String)numOfEntriesString)) {
            errorBuilder.add((Object)new ValidationErrorCollectionRepresentation.ValidationErrorEntry(PREF_NUMOFENTRIES, "gadget.activity.stream.error.pref.numofentries.required"));
        } else if (!this.isValidNumber(numOfEntriesString)) {
            errorBuilder.add((Object)new ValidationErrorCollectionRepresentation.ValidationErrorEntry(PREF_NUMOFENTRIES, "gadget.activity.stream.error.pref.numofentries.number"));
        }
        ImmutableList errorCollection = errorBuilder.build();
        if (Iterables.isEmpty((Iterable)errorCollection)) {
            return Response.ok().cacheControl(NO_CACHE).build();
        }
        return Response.status((int)400).entity((Object)new ValidationErrorCollectionRepresentation((Collection<ValidationErrorCollectionRepresentation.ValidationErrorEntry>)errorCollection)).cacheControl(NO_CACHE).build();
    }

    private boolean hasInvalidKey(String keys, boolean local) {
        return !this.validator.allKeysAreValid(Arrays.asList(keys.split(",")), local);
    }

    private boolean isValidUsername(String username) {
        return this.userManager.resolve(username) != null;
    }

    private boolean isValidNumber(String number) {
        if (NumberUtils.isNumber((String)number)) {
            Long numberOfEntries = Long.valueOf(number);
            return numberOfEntries > 0L && numberOfEntries <= 100L;
        }
        return false;
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

