/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.LocalActivityProvider;
import com.atlassian.streams.spi.ActivityProviderModuleDescriptor;
import com.atlassian.streams.spi.SessionManager;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import org.springframework.beans.factory.annotation.Qualifier;

class LocalActivityProviders
implements Supplier<Iterable<ActivityProvider>> {
    private final PluginAccessor pluginAccessor;
    private final StreamsI18nResolver i18nResolver;
    private final TransactionTemplate transactionTemplate;
    private final SessionManager sessionManager;
    private final ApplicationProperties applicationProperties;
    private final Function<ActivityProviderModuleDescriptor, ActivityProvider> toActivityProviderFunction = new Function<ActivityProviderModuleDescriptor, ActivityProvider>(){

        public ActivityProvider apply(ActivityProviderModuleDescriptor descriptor) {
            return new LocalActivityProvider(descriptor, LocalActivityProviders.this.sessionManager, LocalActivityProviders.this.transactionTemplate, LocalActivityProviders.this.i18nResolver, LocalActivityProviders.this.applicationProperties);
        }
    };

    public LocalActivityProviders(PluginAccessor pluginAccessor, StreamsI18nResolver i18nResolver, @Qualifier(value="sessionManager") SessionManager sessionManager, TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.sessionManager = (SessionManager)Preconditions.checkNotNull((Object)sessionManager, (Object)"sessionManager");
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate, (Object)"transactionTemplate");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    public Iterable<ActivityProvider> get() {
        return Iterables.transform((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ActivityProviderModuleDescriptor.class), this.toActivityProvider());
    }

    private Function<ActivityProviderModuleDescriptor, ActivityProvider> toActivityProvider() {
        return this.toActivityProviderFunction;
    }
}

