/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmFeature;
import com.atlassian.stash.scm.ScmService;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class IsScmFeatureSupportedCondition
implements Condition {
    private final ScmService scmService;
    private Set<ScmFeature> features;

    public IsScmFeatureSupportedCondition(ScmService scmService) {
        this.scmService = scmService;
        this.features = EnumSet.noneOf(ScmFeature.class);
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.parseFeature(params);
        this.parseFeatures(params);
        if (this.features.isEmpty()) {
            throw new PluginParseException("At least one ScmFeature must be specified. Use the \"feature\" or \"features\" parameters to provide ScmFeatures.");
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Repository repository = (Repository)context.get("repository");
        if (repository == null) {
            return false;
        }
        for (ScmFeature feature : this.features) {
            if (this.scmService.isSupported(repository, feature)) continue;
            return false;
        }
        return true;
    }

    private void addFeature(String value) throws PluginParseException {
        try {
            this.features.add(ScmFeature.parse((String)value));
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException("\"" + value + "\" is not a valid ScmFeature.", (Throwable)e);
        }
    }

    private void parseFeature(Map<String, String> params) throws PluginParseException {
        String feature = params.get("feature");
        if (StringUtils.isNotBlank((String)feature)) {
            this.addFeature(feature);
        }
    }

    private void parseFeatures(Map<String, String> params) throws PluginParseException {
        String features = params.get("features");
        if (StringUtils.isNotBlank((String)features)) {
            for (String feature : features.split(",")) {
                this.addFeature(feature);
            }
        }
    }
}

