/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import java.util.Map;

public class CanMergePullRequestCondition
implements Condition {
    public static final String REPOSITORY = "repository";
    protected final PermissionService permissionService;

    public CanMergePullRequestCondition(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.hasPermission(context);
    }

    protected boolean hasPermission(Map<String, Object> context) {
        Repository repository = (Repository)context.get(REPOSITORY);
        return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE);
    }
}

