/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import java.util.Map;

public class IsPersonalProjectCondition
implements Condition {
    public static final String PROJECT = "project";
    private final InternalProjectService projectService;
    private boolean onlyMine;

    public IsPersonalProjectCondition(InternalProjectService projectService) {
        this.projectService = projectService;
    }

    public void init(Map<String, String> params) {
        this.onlyMine = Boolean.parseBoolean(params.get("onlyMine"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Project project = (Project)context.get(PROJECT);
        if (project == null) {
            return false;
        }
        return this.onlyMine ? this.projectService.isPersonalProject(project.getKey()) : project.getType() == ProjectType.PERSONAL;
    }
}

