/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DetailedDatabase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsUnsupportedDatabaseCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(IsUnsupportedDatabaseCondition.class);
    private final DatabaseSupplier databaseSupplier;

    public IsUnsupportedDatabaseCondition(DatabaseSupplier databaseSupplier) {
        this.databaseSupplier = databaseSupplier;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> stringObjectMap) {
        try {
            DetailedDatabase database = this.databaseSupplier.get();
            return database.getSupportLevel() != DatabaseSupportLevel.SUPPORTED;
        }
        catch (Exception e) {
            log.warn("Could not verify database support level", (Throwable)e);
            return false;
        }
    }
}

