/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.http;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryUrlFragment {
    private static final Pattern HOSTING_URL = Pattern.compile("/([^/]+)/([^/]+?)(?:\\.git)?(?:/.*|$)");
    private final String projectKey;
    private final String repositorySlug;

    private RepositoryUrlFragment(String projectKey, String repositorySlug) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Nullable
    public static RepositoryUrlFragment fromPathInfo(@Nonnull String pathInfo) {
        Matcher m = HOSTING_URL.matcher((CharSequence)Preconditions.checkNotNull((Object)pathInfo, (Object)"pathInfo"));
        return m.find() ? new RepositoryUrlFragment(m.group(1), m.group(2)) : null;
    }

    @Nonnull
    public static RepositoryUrlFragment fromRepository(@Nonnull Repository repository) {
        Project project = ((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getProject();
        return new RepositoryUrlFragment(((Project)Preconditions.checkNotNull((Object)project, (Object)"repository.project")).getKey(), repository.getSlug());
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nonnull
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Nonnull
    public String toPath(@Nullable String basePath) {
        StringBuilder builder = new StringBuilder();
        if (basePath == null) {
            builder.append('/');
        } else {
            builder.append(basePath);
            if (!basePath.endsWith("/")) {
                builder.append('/');
            }
        }
        return builder.append(this.projectKey.toLowerCase(Locale.US)).append('/').append(this.repositorySlug).toString();
    }

    @Nonnull
    public String toString() {
        return this.projectKey + "/" + this.repositorySlug;
    }
}

