/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScmUrlRequest {
    private final URI baseUrl;
    private final Repository repository;
    private final StashUser user;

    private ScmUrlRequest(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Nonnull
    public URI getBaseUrl() {
        return this.baseUrl;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public StashUser getUser() {
        return this.user;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public static class Builder {
        private final URI baseUrl;
        private final Repository repository;
        private StashUser user;

        public Builder(@Nonnull Repository repository, @Nonnull URI baseUrl) {
            this.baseUrl = (URI)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        }

        @Nonnull
        public ScmUrlRequest build() {
            return new ScmUrlRequest(this);
        }

        @Nonnull
        public Builder user(@Nullable StashUser value) {
            this.user = value;
            return this;
        }
    }
}

