/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.throttle;

import com.atlassian.stash.Product;
import com.atlassian.stash.exception.ResourceBusyException;
import com.atlassian.stash.help.HelpPathService;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.scm.ScmRequest;
import com.atlassian.stash.scm.http.HttpScmRequest;
import com.atlassian.stash.scm.ssh.SshScmRequest;
import com.atlassian.stash.throttle.ThrottleService;
import com.atlassian.stash.throttle.Ticket;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledScmRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(ThrottledScmRequestFactory.class);
    @VisibleForTesting
    static final String RESOURCE_NAME = "scm-hosting";
    private final ThrottleService throttleService;
    private final I18nService i18nService;
    private final HelpPathService helpPathService;

    public ThrottledScmRequestFactory(ThrottleService throttleService, I18nService i18nService, HelpPathService helpPathService) {
        this.throttleService = (ThrottleService)Preconditions.checkNotNull((Object)throttleService, (Object)"throttleService");
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        this.helpPathService = (HelpPathService)Preconditions.checkNotNull((Object)helpPathService, (Object)"helpPathService");
    }

    @Nullable
    public SshScmRequest throttled(@Nullable SshScmRequest request) {
        return this.throttled(request, SshScmRequest.class);
    }

    @Nullable
    public HttpScmRequest throttled(@Nullable HttpScmRequest request) {
        return this.throttled(request, HttpScmRequest.class);
    }

    private <T extends ScmRequest> T throttled(@Nullable T request, Class<T> clazz) {
        if (request == null || request.isInvalid()) {
            return request;
        }
        return (T)((ScmRequest)clazz.cast(Proxy.newProxyInstance(request.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ThrottlingInvocationHandler(request))));
    }

    private class ThrottlingInvocationHandler
    implements InvocationHandler {
        private final ScmRequest target;

        private ThrottlingInvocationHandler(ScmRequest target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (Ticket ticket = null;){
                if ("handleRequest".equals(method.getName())) {
                    try {
                        ticket = ThrottledScmRequestFactory.this.throttleService.acquireTicket(ThrottledScmRequestFactory.RESOURCE_NAME);
                    }
                    catch (ResourceBusyException e) {
                        this.target.sendError(ThrottledScmRequestFactory.this.i18nService.getMessage("stash.scm.throttled", new Object[0]), ThrottledScmRequestFactory.this.i18nService.getMessage("stash.scm.throttled.detail", new Object[]{Product.NAME}));
                        log.info(String.format("A %s request was denied due to heavy server load. Please see %s for performance guidelines.", ThrottledScmRequestFactory.RESOURCE_NAME, ThrottledScmRequestFactory.this.helpPathService.getPageUrl("stash.help.scaling")));
                        Object var6_8 = null;
                        if (ticket != null) {
                            ticket.close();
                        }
                        return var6_8;
                    }
                }
                Object e = method.invoke((Object)this.target, args);
                return e;
            }
        }
    }
}

