/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryUrlFragment {
    private static final Pattern HOSTING_URL = Pattern.compile("/([^/]+)/([^/]+?)(?:\\.git)?(?:/.*|$)");
    private final String projectKey;
    private final String repositorySlug;

    private RepositoryUrlFragment(String projectKey, String repositorySlug) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Nullable
    public static RepositoryUrlFragment fromPathInfo(@Nonnull String pathInfo) {
        Matcher m = HOSTING_URL.matcher(pathInfo);
        return m.find() ? new RepositoryUrlFragment(m.group(1), m.group(2)) : null;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nonnull
    public String getRepositorySlug() {
        return this.repositorySlug;
    }
}

