/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.exception.CommandCanceledException;
import com.atlassian.stash.exception.CommandFailedException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.scm.CommandExitHandler;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultCommandExitHandler
implements CommandExitHandler {
    protected final I18nService i18nService;

    public DefaultCommandExitHandler(@Nonnull I18nService i18nService) {
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
    }

    public void onCancel(@Nonnull String command, int exitCode, @Nullable String stdErr, @Nullable Throwable thrown) {
        if (thrown != null) {
            throw new CommandCanceledException(this.i18nService.createKeyedMessage("stash.scm.command.canceled", new Object[]{command}), thrown);
        }
    }

    public void onExit(@Nonnull String command, int exitCode, @Nullable String stdErr, @Nullable Throwable thrown) {
        if (this.isError(command, exitCode, stdErr, thrown)) {
            this.onError(command, exitCode, stdErr, thrown);
        }
    }

    protected boolean isError(String command, int exitCode, String stdErr, Throwable thrown) {
        return exitCode != 0 || thrown != null || StringUtils.isNotBlank((String)stdErr);
    }

    protected void onError(String command, int exitCode, String stdErr, Throwable thrown) {
        if (StringUtils.isBlank((String)stdErr)) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("stash.scm.command.failed", new Object[]{command, exitCode}), thrown);
        }
        throw new CommandFailedException(this.i18nService.createKeyedMessage("stash.scm.command.failed.saying", new Object[]{command, exitCode, stdErr}), thrown);
    }
}

