/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.hook;

import com.atlassian.stash.hook.HookRequestHandle;
import com.atlassian.utils.process.ExternalProcessSettings;
import java.util.Map;

public class HookUtils {
    private HookUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static void configure(HookRequestHandle requestHandle, ExternalProcessSettings settings) {
        HookUtils.configureEnvironment(requestHandle, settings.getEnvironment());
    }

    public static void configure(HookRequestHandle requestHandle, ProcessBuilder builder) {
        HookUtils.configureEnvironment(requestHandle, builder.environment());
    }

    private static void configureEnvironment(HookRequestHandle requestHandle, Map<String, String> environment) {
        environment.put("STASH_HOOK_CALLBACK", requestHandle.getCallbackScript().getAbsolutePath());
        environment.put("STASH_HOOK_COORDINATOR", requestHandle.getCoordinatorScript().getAbsolutePath());
        environment.put("STASH_HOOK_ADDRESS", requestHandle.getHostAddress());
        environment.put("STASH_HOOK_PORT", Integer.toString(requestHandle.getPort()));
        environment.put("STASH_HOOK_REQUEST_ID", requestHandle.getRequestId());
    }
}

