/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.comment;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentAttributeContext;
import com.atlassian.stash.comment.CommentAttributeProvider;
import com.atlassian.stash.comment.CommentableVisitor;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class AbstractCommentAttributeProvider
implements CommentAttributeProvider {
    @Override
    public void provideAttributes(@Nonnull CommentAttributeContext context) {
        this.doProvideAttribute(this.flatten(context));
    }

    protected abstract void doProvideAttribute(@Nonnull CommentAttributeContext var1);

    private CommentAttributeContext flatten(final CommentAttributeContext context) {
        final Set<Comment> comments = this.flatten(context, (ImmutableSet.Builder<Comment>)new ImmutableSet.Builder());
        return new CommentAttributeContext(){

            @Override
            public <T> T accept(CommentableVisitor<T> visitor) {
                return context.accept(visitor);
            }

            @Override
            public void addAttribute(@Nonnull Comment comment, @Nonnull String key, @Nonnull String value) {
                context.addAttribute(comment, key, value);
            }

            @Override
            public Iterator<Comment> iterator() {
                return comments.iterator();
            }
        };
    }

    private Set<Comment> flatten(Iterable<Comment> comments, ImmutableSet.Builder<Comment> accumulator) {
        for (Comment comment : comments) {
            accumulator.add((Object)comment);
            this.flatten(comment.getComments(), accumulator);
        }
        return accumulator.build();
    }
}

