/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DeleteCommandParameters
extends AbstractCommandParameters {
    private final Set<Integer> forkIds;
    private final boolean lastInHierarchy;

    private DeleteCommandParameters(Set<Integer> forkIds, boolean lastInHierarchy) {
        this.forkIds = (Set)Preconditions.checkNotNull(forkIds, (Object)"forkIds");
        this.lastInHierarchy = lastInHierarchy;
        if (lastInHierarchy) {
            Preconditions.checkArgument((boolean)forkIds.isEmpty(), (Object)"A repository cannot have forks and be the last in its hierarchy");
        }
    }

    @Nonnull
    public Set<Integer> getForkIds() {
        return this.forkIds;
    }

    public boolean hasForks() {
        return !this.forkIds.isEmpty();
    }

    public boolean isLastInHierarchy() {
        return this.lastInHierarchy;
    }

    public static class Builder {
        private ImmutableSet.Builder<Integer> forkIds = ImmutableSet.builder();
        private boolean lastInHierarchy;

        public DeleteCommandParameters build() {
            return new DeleteCommandParameters((Set)this.forkIds.build(), this.lastInHierarchy);
        }

        public Builder forkIds(@Nonnull Iterable<Integer> value) {
            this.forkIds.addAll(value);
            return this;
        }

        public Builder lastInHierarchy() {
            this.lastInHierarchy = true;
            return this;
        }
    }
}

