/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.stash.util.Weighted;
import javax.annotation.Nonnull;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class BaseWeightedModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements Weighted,
Comparable<BaseWeightedModuleDescriptor<T>> {
    private int weight;

    public BaseWeightedModuleDescriptor(ModuleFactory moduleFactory, int defaultWeight) {
        super(moduleFactory);
        this.weight = defaultWeight;
    }

    @Override
    public int compareTo(BaseWeightedModuleDescriptor<T> otherDescriptor) {
        return Weighted.COMPARABLE.compare(this, otherDescriptor);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        Attribute weightAttr = element.attribute("weight");
        if (weightAttr != null) {
            try {
                this.weight = Integer.parseInt(weightAttr.getValue());
            }
            catch (NumberFormatException e) {
                throw new PluginParseException("The 'weight' attribute must be a number.", (Throwable)e);
            }
        }
    }
}

