/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.springframework.util.ReflectionUtils;

public class LatchedInvocationHandler
implements InvocationHandler {
    private final Object delegate;
    private final CountDownLatch latch;

    public LatchedInvocationHandler(Object delegate, CountDownLatch latch) {
        this.delegate = delegate;
        this.latch = latch;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isLatched(method)) {
            this.latch.await();
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)this.getDelegate(method), (Object[])args);
    }

    protected Object getDelegate(Method method) {
        return this.delegate;
    }

    protected boolean isLatched(Method method) {
        return method.getDeclaringClass() != Object.class;
    }
}

