/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Predicate;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.access.expression.method.PublicMethodSecurityExpressionRoot;
import org.springframework.security.core.Authentication;

public class ExtendedMethodSecurityExpressionRoot
extends PublicMethodSecurityExpressionRoot {
    private final ThreadLocal<Boolean> permissionLoopGuard;
    private PermissionService permissionService;
    private Object returnObject;

    public ExtendedMethodSecurityExpressionRoot(Authentication a, ThreadLocal<Boolean> evaluationPermissions) {
        super(a);
        this.permissionLoopGuard = evaluationPermissions;
    }

    public boolean hasAnyPermission(Permission permission) {
        return this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasAnyUserPermission(permission);
            }
        });
    }

    public boolean hasGlobalPermission(Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasGlobalPermission(permission);
            }
        });
    }

    public boolean hasGlobalPermission(final StashUser user, Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasGlobalPermission(user, permission);
            }
        });
    }

    public boolean hasGlobalPermission(final String username, Permission permission) {
        CommonValidations.validateGlobalPermission(permission);
        return this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasGlobalPermission(username, permission);
            }
        });
    }

    public boolean hasProjectPermission(final Project project, Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        return project == null || this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasProjectPermission(project, permission);
            }
        });
    }

    public boolean hasProjectPermission(final int projectId, Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        return this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasProjectPermission(projectId, permission);
            }
        });
    }

    public boolean hasRepositoryPermission(final Repository repository, Permission permission) {
        CommonValidations.validateRepositoryPermission(permission);
        return repository == null || this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasRepositoryPermission(repository, permission);
            }
        });
    }

    public boolean hasRepositoryPermission(final int repositoryId, Permission permission) {
        CommonValidations.validateRepositoryPermission(permission);
        return this.applyPredicate(permission, new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.hasRepositoryPermission(repositoryId, permission);
            }
        });
    }

    public boolean isCurrentUser(StashUser user) {
        return user != null && this.isCurrentUser(user.getName());
    }

    public boolean isCurrentUser(String username) {
        StashUserAuthenticationToken user = this.resolveToken();
        return user != null && StringUtils.equals((String)user.getName(), (String)username);
    }

    public boolean isProjectAccessible(final Project project) {
        return project == null || this.applyPredicate(null, new Predicate<Permission>(){

            public boolean apply(Permission ignored) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.isProjectAccessible(project);
            }
        });
    }

    public boolean isProjectAccessible(final int projectId) {
        return this.applyPredicate(null, new Predicate<Permission>(){

            public boolean apply(Permission ignored) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.isProjectAccessible(projectId);
            }
        });
    }

    public boolean isRepositoryAccessible(final Repository repository) {
        return repository == null || this.applyPredicate(null, new Predicate<Permission>(){

            public boolean apply(Permission ignored) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.isRepositoryAccessible(repository);
            }
        });
    }

    public boolean isRepositoryAccessible(final int repositoryId) {
        return this.applyPredicate(null, new Predicate<Permission>(){

            public boolean apply(Permission ignored) {
                return ExtendedMethodSecurityExpressionRoot.this.permissionService.isRepositoryAccessible(repositoryId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyPredicate(Permission permission, Predicate<Permission> predicate) {
        this.enterPermissionCheck();
        try {
            boolean bl = predicate.apply((Object)permission);
            return bl;
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    private void enterPermissionCheck() {
        if (this.permissionLoopGuard.get() != null) {
            throw new IllegalStateException("Nested method authorisation check detected. This would have led to an infinite loop!");
        }
        this.permissionLoopGuard.set(Boolean.TRUE);
    }

    private void exitPermissionCheck() {
        this.permissionLoopGuard.remove();
    }

    private StashUserAuthenticationToken resolveToken() {
        if (this.authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)this.authentication;
        }
        return null;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

