/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.ExtendedAuthenticationTrustResolver;
import com.atlassian.stash.internal.user.ExtendedMethodSecurityExpressionRoot;
import com.atlassian.stash.user.PermissionService;
import com.google.common.annotations.VisibleForTesting;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;

public class ExtendedMethodSecurityExpressionHandler
extends DefaultMethodSecurityExpressionHandler
implements Ordered {
    private final ThreadLocal<Boolean> permissionLoopGuard = new ThreadLocal();
    private final AuthenticationTrustResolver trustResolver = new ExtendedAuthenticationTrustResolver();
    private ApplicationContext applicationContext;
    private volatile PermissionService permissionService;

    public int getOrder() {
        return 0;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        super.setApplicationContext(applicationContext);
    }

    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        ExtendedMethodSecurityExpressionRoot root = new ExtendedMethodSecurityExpressionRoot(authentication, this.permissionLoopGuard);
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setPermissionService(this.getPermissionService());
        root.setThis(invocation.getThis());
        root.setTrustResolver(this.trustResolver);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            AuthenticationTrustResolver authenticationTrustResolver = this.trustResolver;
            synchronized (authenticationTrustResolver) {
                if (this.permissionService == null) {
                    this.permissionService = (PermissionService)this.applicationContext.getBean(PermissionService.class);
                }
            }
        }
        return this.permissionService;
    }
}

