/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.SimpleValueWrapper;

public class HazelcastCacheManager
implements CacheManager {
    private static final DataSerializable NULL = new NullDataSerializable();
    private final HazelcastInstance hazelcast;

    public HazelcastCacheManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
    }

    @Nonnull
    public Cache getCache(@Nonnull String name) {
        return new HazelcastCache(this.hazelcast.getMap((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
    }

    public Collection<String> getCacheNames() {
        HashSet names = Sets.newHashSet();
        for (DistributedObject distributedObject : this.hazelcast.getDistributedObjects()) {
            if (!(distributedObject instanceof IMap)) continue;
            names.add(distributedObject.getName());
        }
        return names;
    }

    private static class NullDataSerializable
    implements DataSerializable {
        private NullDataSerializable() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public void readData(ObjectDataInput in) {
        }

        public void writeData(ObjectDataOutput out) {
        }
    }

    private static class HazelcastCache
    implements Cache {
        private final IMap<Object, Object> map;

        private HazelcastCache(IMap<Object, Object> map) {
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }

        public void evict(Object key) {
            this.map.evict(key);
        }

        public Cache.ValueWrapper get(Object key) {
            return this.loadWrapper(key, null, true);
        }

        public <T> T get(Object key, Class<T> type) {
            return type.cast(this.fromStore(this.accessMap(key, null, true)));
        }

        public String getName() {
            return this.map.getName();
        }

        public Object getNativeCache() {
            return this.map;
        }

        public void put(Object key, Object value) {
            this.map.set(key, this.toStore(value));
        }

        public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
            return this.loadWrapper(key, value, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object accessMap(Object key, Object value, boolean get) {
            Thread currentThread = Thread.currentThread();
            ClassLoader original = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(NullDataSerializable.class.getClassLoader());
                Object object = get ? this.map.get(key) : this.map.putIfAbsent(key, this.toStore(value));
                return object;
            }
            finally {
                currentThread.setContextClassLoader(original);
            }
        }

        private Object fromStore(Object value) {
            return NULL.equals(value) ? null : value;
        }

        private Cache.ValueWrapper loadWrapper(Object key, Object value, boolean get) {
            Object result = this.accessMap(key, value, get);
            return result == null ? null : new SimpleValueWrapper(this.fromStore(result));
        }

        private Object toStore(Object value) {
            return value == null ? NULL : value;
        }
    }
}

