/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.server.analytics.ConfigAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.JavaAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.SystemAttributesAnalyticsEvent;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.collect.ImmutableMap;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class InstanceAnalyticsJob {
    private static final JobId INFORMATION_ANALYTICS_JOB_ID = JobId.of((String)InstanceAnalyticsJobRunner.class.getSimpleName());
    private static final JobRunnerKey INFORMATION_ANALYTICS_JOB_RUNNER_KEY = JobRunnerKey.of((String)InstanceAnalyticsJobRunner.class.getName());
    private final EventPublisher eventPublisher;
    private final LicenseService licenseService;
    private final InternalProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final InternalPullRequestService pullRequestService;
    private final InternalRepositoryService repositoryService;
    private final SchedulerService schedulerService;

    public InstanceAnalyticsJob(EventPublisher eventPublisher, LicenseService licenseService, InternalProjectService projectService, ApplicationPropertiesService propertiesService, InternalPullRequestService pullRequestService, InternalRepositoryService repositoryService, SchedulerService schedulerService) {
        this.eventPublisher = eventPublisher;
        this.licenseService = licenseService;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.schedulerService = schedulerService;
    }

    public void init() throws Exception {
        this.scheduleJob();
    }

    public void destroy() {
        this.unscheduleJob();
    }

    private ImmutableMap.Builder addPullRequestCount(ImmutableMap.Builder<String, Object> mapBuilder) {
        Map countsByState = this.pullRequestService.getCountsByState();
        return mapBuilder.put((Object)"pullRequests", (Object)new ImmutableMap.Builder().put((Object)"declined", countsByState.get(PullRequestState.DECLINED)).put((Object)"merged", countsByState.get(PullRequestState.MERGED)).put((Object)"open", countsByState.get(PullRequestState.OPEN)).build());
    }

    private Map<String, Object> getOperatingSystemInfo() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return ImmutableMap.of((Object)"freePhysicalMemory", (Object)osBean.getFreePhysicalMemorySize(), (Object)"totalPhysicalMemory", (Object)osBean.getTotalPhysicalMemorySize());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ImmutableMap.of();
        }
    }

    private void publishAnalyticsEvent() {
        Runtime rt = Runtime.getRuntime();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ImmutableMap jre = ImmutableMap.of((Object)"vendor", (Object)System.getProperty("java.vendor"), (Object)"version", (Object)System.getProperty("java.version"), (Object)"vm.name", (Object)System.getProperty("java.vm.name"), (Object)"vm.arch", (Object)System.getProperty("sun.arch.data.model"));
        ImmutableMap jvm = ImmutableMap.of((Object)"availableProcessors", (Object)rt.availableProcessors(), (Object)"freeMemory", (Object)rt.freeMemory(), (Object)"maxMemory", (Object)rt.maxMemory(), (Object)"totalMemory", (Object)rt.totalMemory(), (Object)"uptime", (Object)runtimeMXBean.getUptime());
        ImmutableMap os = ImmutableMap.of((Object)"arch", (Object)System.getProperty("os.arch"), (Object)"name", (Object)System.getProperty("os.name"), (Object)"version", (Object)System.getProperty("os.version"));
        Map<String, Object> system = this.getOperatingSystemInfo();
        ImmutableMap jdbc = ImmutableMap.of((Object)"driver", (Object)this.propertiesService.getJdbcDriver(), (Object)"version", (Object)this.propertiesService.getJdbcDriverVersion());
        int maxNumberOfUsers = -1;
        StashLicense license = this.licenseService.get();
        if (license != null) {
            maxNumberOfUsers = license.getMaximumNumberOfUsers();
        }
        ImmutableMap.Builder usageBuilder = new ImmutableMap.Builder().put((Object)"licensedUsers", (Object)this.licenseService.getLicensedUsersCount()).put((Object)"maxLicensedUsers", (Object)maxNumberOfUsers).put((Object)"projectCount", (Object)this.projectService.getCount()).put((Object)"repositoryCount", (Object)this.repositoryService.getCount());
        this.addPullRequestCount((ImmutableMap.Builder<String, Object>)usageBuilder);
        ImmutableMap usage = usageBuilder.build();
        this.eventPublisher.publish((Object)new JavaAttributesAnalyticsEvent(this, (Map<String, Object>)jre, (Map<String, Object>)jvm));
        this.eventPublisher.publish((Object)new SystemAttributesAnalyticsEvent(this, (Map<String, Object>)os, system));
        this.eventPublisher.publish((Object)new ConfigAttributesAnalyticsEvent(this, (Map<String, Object>)jdbc, (Map<String, Object>)usage));
    }

    private void scheduleJob() throws SchedulerServiceException {
        long interval = TimeUnit.DAYS.toMillis(1L);
        long firstRun = TimeUnit.MINUTES.toMillis(30L);
        InstanceAnalyticsJobRunner jobRunner = new InstanceAnalyticsJobRunner();
        this.schedulerService.registerJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        this.schedulerService.scheduleJob(INFORMATION_ANALYTICS_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)INFORMATION_ANALYTICS_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + firstRun))));
    }

    private void unscheduleJob() {
        this.schedulerService.unscheduleJob(INFORMATION_ANALYTICS_JOB_ID);
        this.schedulerService.unregisterJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY);
    }

    private class InstanceAnalyticsJobRunner
    implements JobRunner {
        private InstanceAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
            InstanceAnalyticsJob.this.publishAnalyticsEvent();
            return JobRunnerResponse.success();
        }
    }
}

