/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.avatar.AvatarService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserEquality;
import com.atlassian.stash.util.UrlUtils;
import com.google.common.base.Preconditions;
import java.net.URI;

public class DefaultUserProfile
implements UserProfile {
    private static final int DEFAULT_AVATAR_SIZE = 128;
    private final StashUser stashUser;
    private final NavBuilder navBuilder;
    private final AvatarService avatarService;

    public DefaultUserProfile(StashUser stashUser, NavBuilder navBuilder, AvatarService avatarService) {
        this.stashUser = (StashUser)Preconditions.checkNotNull((Object)stashUser);
        this.navBuilder = (NavBuilder)Preconditions.checkNotNull((Object)navBuilder);
        this.avatarService = (AvatarService)Preconditions.checkNotNull((Object)avatarService);
    }

    public String getEmail() {
        return this.stashUser.getEmailAddress();
    }

    public String getFullName() {
        return this.stashUser.getDisplayName();
    }

    public UserKey getUserKey() {
        return UserKey.fromLong((long)this.stashUser.getId().intValue());
    }

    public String getUsername() {
        return this.stashUser.getName();
    }

    public URI getProfilePictureUri(int width, int height) {
        return this.getUrlForPerson(width);
    }

    public URI getProfilePictureUri() {
        return this.getUrlForPerson(128);
    }

    public URI getProfilePageUri() {
        String viewUserUrl = this.navBuilder.admin().users().view(this.stashUser.getName()).buildRelNoContext();
        return UrlUtils.uncheckedCreateURI((String)viewUserUrl);
    }

    public StashUser getUser() {
        return this.stashUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUserProfile that = (DefaultUserProfile)o;
        return StashUserEquality.equals((StashUser)this.getUser(), (Object)that.getUser());
    }

    public int hashCode() {
        return this.stashUser.hashCode();
    }

    protected URI getUrlForPerson(int width) {
        boolean useHttps = this.navBuilder.buildBaseUrl().startsWith("https");
        String avatarUrl = this.avatarService.getUrlForPerson((Person)this.stashUser, new AvatarRequest(useHttps, width));
        return UrlUtils.uncheckedCreateURI((String)avatarUrl);
    }
}

