/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.request.RequestContext;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component(value="requestContext")
@AvailableToPlugins(value=RequestContext.class)
public class CurrentRequestContext
implements RequestContext,
ApplicationListener<ContextRefreshedEvent> {
    private RequestManager requestManager;

    public void addCleanupCallback(@Nonnull Runnable callback) {
        this.current().addCleanupCallback((Runnable)Preconditions.checkNotNull((Object)callback, (Object)"callback"));
    }

    public void addLabel(@Nonnull String label) {
        this.current().addLabel(label);
    }

    @Nullable
    public StashAuthenticationContext getAuthenticationContext() {
        return this.current().getAuthenticationContext();
    }

    @Nonnull
    public String getAction() {
        return this.current().getAction();
    }

    @Nullable
    public String getDetails() {
        return this.current().getDetails();
    }

    @Nonnull
    public String getId() {
        return this.current().getId();
    }

    @Nonnull
    public String getProtocol() {
        return this.current().getProtocol();
    }

    @Nonnull
    public Object getRawRequest() {
        return this.current().getRawRequest();
    }

    @Nonnull
    public Object getRawResponse() {
        return this.current().getRawResponse();
    }

    @Nullable
    public String getRemoteAddress() {
        return this.current().getRemoteAddress();
    }

    @Nullable
    public String getSessionId() {
        return this.current().getSessionId();
    }

    public boolean hasSessionId() {
        return this.current().hasSessionId();
    }

    public boolean isActive() {
        return this.requestManager != null && this.requestManager.getRequestContext() != null;
    }

    public boolean isSecure() {
        return this.current().isSecure();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.requestManager = (RequestManager)event.getApplicationContext().getBean(RequestManager.class);
    }

    private RequestContext current() {
        RequestContext context = this.requestManager.getRequestContext();
        Preconditions.checkState((context != null ? 1 : 0) != 0, (Object)"There is no current RequestContext");
        return context;
    }
}

