/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentChain;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentOperations;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class OperationCommentPostProcessor
implements CommentPostProcessor {
    private final StashAuthenticationContext authenticationContext;
    private final PermissionService permissionService;

    public OperationCommentPostProcessor(StashAuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
    }

    @Override
    public InternalComment process(InternalCommentable entity, InternalComment rootComment) {
        this.processAll(entity, (List<InternalComment>)ImmutableList.of((Object)rootComment));
        return rootComment;
    }

    @Override
    public List<InternalComment> processAll(InternalCommentable entity, List<InternalComment> rootComments) {
        if (rootComments.isEmpty()) {
            return rootComments;
        }
        CommentChain allComments = new CommentChain(rootComments);
        InternalRepository repository = entity.getScopeRepository();
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        boolean isRepoAdmin = this.isRepoAdmin(repository);
        for (InternalComment comment : allComments) {
            this.process(comment, currentUser, isRepoAdmin);
        }
        return rootComments;
    }

    private void process(InternalComment comment, StashUser currentUser, boolean isRepoAdmin) {
        if (comment.getPermittedOperations() == null) {
            comment.setPermittedOperations(InternalCommentOperations.of((boolean)OperationCommentPostProcessor.canEdit(currentUser, (Comment)comment), (boolean)OperationCommentPostProcessor.canDelete(currentUser, (Comment)comment, isRepoAdmin)));
        }
    }

    private boolean isRepoAdmin(InternalRepository repository) {
        return this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_ADMIN);
    }

    private static boolean canEdit(StashUser currentUser, Comment comment) {
        return comment.getAuthor().equals(currentUser);
    }

    private static boolean canDelete(StashUser currentUser, Comment comment, boolean isRepoAdmin) {
        return isRepoAdmin || comment.getAuthor().equals(currentUser);
    }
}

