/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class CompositeCommentPostProcessor
implements CommentPostProcessor {
    private final List<CommentPostProcessor> postProcessors;

    public CompositeCommentPostProcessor(List<CommentPostProcessor> postProcessors) {
        this.postProcessors = ImmutableList.copyOf(postProcessors);
    }

    @Override
    @Profiled
    public InternalComment process(InternalCommentable entity, InternalComment comment) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Timer timer = TimerUtils.start((String)String.format("%s.process comment ID=%d", postProcessor.getClass().getName(), comment.getId()));
            Throwable throwable = null;
            try {
                comment = postProcessor.process(entity, comment);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (timer == null) continue;
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                timer.close();
            }
        }
        return comment;
    }

    @Override
    @Profiled
    public List<InternalComment> processAll(InternalCommentable entity, List<InternalComment> comments) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Timer timer = TimerUtils.start((String)String.format("%s.processAll %d comments", postProcessor.getClass().getName(), comments.size()));
            Throwable throwable = null;
            try {
                comments = postProcessor.processAll(entity, comments);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (timer == null) continue;
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                timer.close();
            }
        }
        return comments;
    }
}

