/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.content.AbstractProviderContext;
import com.atlassian.stash.internal.plugin.PullRequestAttributeProviderDescriptor;
import com.atlassian.stash.internal.plugin.PullRequestMergeabilityPropertyProviderDescriptor;
import com.atlassian.stash.internal.plugin.PullRequestPropertyProviderDescriptor;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeability;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAttributeContext;
import com.atlassian.stash.pull.PullRequestAttributeProvider;
import com.atlassian.stash.pull.PullRequestMergeability;
import com.atlassian.stash.pull.PullRequestMergeabilityPropertyProvider;
import com.atlassian.stash.pull.PullRequestPropertyContext;
import com.atlassian.stash.pull.PullRequestPropertyProvider;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.atlassian.stash.util.Page;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pullRequestEnricher")
public class PluginPullRequestEnricher
implements PullRequestEnricher {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginPullRequestEnricher(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Iterable<InternalPullRequest> enrich(@Nonnull Iterable<InternalPullRequest> pullRequests) {
        Context context = new Context(pullRequests);
        this.enrich(context);
        return ImmutableList.copyOf((Iterable)Iterables.transform(pullRequests, (Function)new Enricher(context)));
    }

    @Override
    @Nonnull
    public Page<InternalPullRequest> enrich(@Nonnull Page<InternalPullRequest> pullRequests) {
        Context context = new Context(pullRequests);
        this.enrich(context);
        return pullRequests.transform((Function)new Enricher(context));
    }

    @Override
    @Nonnull
    public PullRequestMergeability enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull SimplePullRequestMergeability mergeability) {
        PropertyMap.Builder builder = new PropertyMap.Builder();
        for (PullRequestMergeabilityPropertyProvider provider : this.getMergeabilityPropertyProviders()) {
            Map properties = provider.provideProperties((PullRequest)pullRequest, (PullRequestMergeability)mergeability);
            if (properties == null) continue;
            builder.properties(properties);
        }
        mergeability.setProperties(builder.build());
        return mergeability;
    }

    private void enrich(Context context) {
        for (PullRequestAttributeProvider provider : this.getAttributeProviders()) {
            provider.provideAttributes((PullRequestAttributeContext)context);
        }
        for (PullRequestPropertyProvider propertyProvider : this.getPropertyProviders()) {
            propertyProvider.provideProperties((PullRequestPropertyContext)context);
        }
    }

    private List<PullRequestAttributeProvider> getAttributeProviders() {
        return Chainable.chain((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(PullRequestAttributeProviderDescriptor.class)).transform(ModuleDescriptorUtils.toModule()).toList();
    }

    private List<PullRequestPropertyProvider> getPropertyProviders() {
        return Chainable.chain((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(PullRequestPropertyProviderDescriptor.class)).transform(ModuleDescriptorUtils.toModule()).toList();
    }

    private List<PullRequestMergeabilityPropertyProvider> getMergeabilityPropertyProviders() {
        return Chainable.chain((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(PullRequestMergeabilityPropertyProviderDescriptor.class)).transform(ModuleDescriptorUtils.toModule()).toList();
    }

    private static class Enricher
    implements Function<InternalPullRequest, InternalPullRequest> {
        private final Context context;

        public Enricher(Context context) {
            this.context = context;
        }

        public InternalPullRequest apply(InternalPullRequest pullRequest) {
            pullRequest.setAttributes(this.context.getAttributesFor(pullRequest));
            pullRequest.setProperties(this.context.getPropertiesFor(pullRequest));
            return pullRequest;
        }
    }

    private static class Context
    extends AbstractProviderContext<PullRequest>
    implements PullRequestAttributeContext,
    PullRequestPropertyContext {
        private Context(Iterable<? extends PullRequest> pullRequests) {
            super(pullRequests);
        }

        private Context(Page<? extends PullRequest> pullRequests) {
            this(pullRequests.getValues());
        }
    }
}

