/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.internal.migration.MigrationService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
@Service(value="migrationService")
public class DefaultMigrationService
implements MigrationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMigrationService.class);
    private final DatabaseManager databaseManager;
    private final I18nService i18nService;
    private final MaintenanceService maintenanceService;
    private final MaintenanceTaskFactory maintenanceTaskFactory;

    @Autowired
    public DefaultMigrationService(DatabaseManager databaseManager, I18nService i18nService, MaintenanceService maintenanceService, MaintenanceTaskFactory maintenanceTaskFactory) {
        this.databaseManager = databaseManager;
        this.i18nService = i18nService;
        this.maintenanceService = maintenanceService;
        this.maintenanceTaskFactory = maintenanceTaskFactory;
    }

    @Nonnull
    public MaintenanceTaskMonitor migrate(@Nonnull DataSourceConfiguration newConfiguration) {
        Preconditions.checkNotNull((Object)newConfiguration, (Object)"newConfiguration");
        try {
            return this.maintenanceService.start((MaintenanceTask)this.maintenanceTaskFactory.migrationTask(newConfiguration), MaintenanceType.MIGRATION);
        }
        catch (IllegalStateException e) {
            log.error("An attempt to start a migration was blocked because maintenance is already in progress");
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.already.running", new Object[0]));
        }
    }

    @Nonnull
    public MaintenanceTaskMonitor setup(@Nonnull DataSourceConfiguration newConfiguration) {
        Preconditions.checkNotNull((Object)newConfiguration, (Object)"newConfiguration");
        try {
            return this.maintenanceService.start((MaintenanceTask)this.maintenanceTaskFactory.setupTask(newConfiguration), MaintenanceType.MIGRATION);
        }
        catch (IllegalStateException e) {
            log.error("An attempt to setup the database was blocked because maintenance is already in progress");
            throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.already.running", new Object[0]));
        }
    }

    public void validateConfiguration(@Nonnull DataSourceConfiguration configuration) {
        this.databaseManager.validateConfiguration(configuration);
    }
}

