/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.BackupDataSourceSupplier;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseBackupMonitor;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseMigrationDao;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.atlassian.stash.util.SimpleCancelState;
import com.google.common.base.Preconditions;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBackupStep
implements LiquibaseBackupMonitor,
MaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseBackupStep.class);
    public static final String DEFAULT_AUTHOR = "backup";
    private final StashAuthenticationContext authContext;
    private final CancelState cancelState;
    private final BackupDataSourceSupplier backupDataSourceSupplier;
    private final I18nService i18nService;
    private final LiquibaseMigrationDao migrationDao;
    private volatile long rowsProcessed;
    private final BackupState state;
    private volatile long totalRows;

    public DatabaseBackupStep(BackupState state, StashAuthenticationContext authenticationContext, BackupDataSourceSupplier backupDataSourceSupplier, I18nService i18nService, LiquibaseMigrationDao migrationDao) {
        this.authContext = authenticationContext;
        this.cancelState = new SimpleCancelState();
        this.backupDataSourceSupplier = backupDataSourceSupplier;
        this.i18nService = i18nService;
        this.migrationDao = migrationDao;
        this.state = state;
    }

    public void cancel() {
        this.cancelState.cancel(this.i18nService.createKeyedMessage("stash.backup.backup.liquibase.canceled", new Object[]{Product.NAME}));
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("stash.backup.backup.liquibase", new Object[]{Product.NAME}), this.rowsProcessed == 0L || this.totalRows == 0L ? 0 : (int)Math.min(100L, 100L * this.rowsProcessed / this.totalRows));
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry("stash-data.xml");
            stream.putNextEntry(entry);
            log.debug("Backing up {} data to {}", (Object)Product.NAME, (Object)"stash-data.xml");
            try {
                this.backupDataSourceSupplier.setDataSource(this.state.getSourceDatabase().getDataSource());
                this.migrationDao.backup((OutputStream)new CloseShieldOutputStream((OutputStream)stream), this.getAuthor(), (LiquibaseBackupMonitor)this, this.cancelState);
            }
            catch (LiquibaseDataAccessException e) {
                throw new BackupException(this.i18nService.createKeyedMessage("stash.backup.fail", new Object[0]), (Throwable)e);
            }
            stream.closeEntry();
        }
        catch (IOException e) {
            throw new BackupException(this.i18nService.createKeyedMessage("stash.backup.liquibase.failed", new Object[]{Product.NAME}), (Throwable)e);
        }
    }

    public void rowWritten() {
        ++this.rowsProcessed;
    }

    public void started(long totalRows) {
        this.totalRows = totalRows;
    }

    private String getAuthor() {
        return this.authContext.isAuthenticated() ? this.authContext.getCurrentUser().getName() : DEFAULT_AUTHOR;
    }
}

