/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.activeobjects.spi.AbstractBackupProgressMonitor;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;

class AoBackupProgressMonitor
extends AbstractBackupProgressMonitor {
    static final int SCHEMA_PROGRESS = 20;
    private final I18nService i18nService;
    private int tableCount;
    private int tablesProcessed;
    private volatile int progress;
    private volatile String i18nKey;

    public AoBackupProgressMonitor(I18nService i18nService) {
        this.i18nService = i18nService;
        this.i18nKey = "stash.backup.backup.activeobjects";
    }

    public void beginTableDefinitionsBackup() {
        this.i18nKey = "stash.backup.activeobjects.backup.definitions";
    }

    public void beginTablesBackup() {
        this.i18nKey = "stash.backup.activeobjects.backup.data";
    }

    public void endTableBackup(String tableName) {
        this.progress = 20 + ++this.tablesProcessed * 80 / this.tableCount;
    }

    public void endTableDefinitionsBackup() {
        this.progress = 20;
    }

    public void endTablesBackup() {
        this.progress = 100;
    }

    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage(this.i18nKey, new Object[0]), this.progress);
    }

    public void updateTotalNumberOfTablesToBackup(int tableCount) {
        this.tableCount = tableCount;
    }
}

