/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseAffixed;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.migration.MigrationException;
import com.atlassian.stash.util.Progress;
import com.atlassian.stash.util.ProgressImpl;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ReleaseAffixedDatabaseStep
extends AbstractMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(ReleaseAffixedDatabaseStep.class);
    private final List<DatabaseAffixed> affixes;
    private final I18nService i18nService;
    private volatile boolean released;

    @Autowired
    public ReleaseAffixedDatabaseStep(I18nService i18nService, List<DatabaseAffixed> affixes) {
        this.affixes = ImmutableList.copyOf(affixes);
        this.i18nService = i18nService;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.i18nService.getMessage("stash.migration.releasingdatabase", new Object[0]), this.released ? 100 : 0);
    }

    public void run() {
        for (DatabaseAffixed affix : this.affixes) {
            if (this.isCanceled()) {
                return;
            }
            try {
                affix.release();
            }
            catch (Exception e) {
                Class componentClass = AopUtils.getTargetClass((Object)affix);
                log.error("{} failed to release the current database", (Object)componentClass.getName(), (Object)e);
                throw new MigrationException(this.i18nService.createKeyedMessage("stash.migration.releasedatabasefailed", new Object[0]));
            }
        }
        this.released = true;
    }
}

