/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.idx.ChangesetAttributeConfiguration;
import com.atlassian.stash.idx.ChangesetAttributeConfigurationModuleDescriptor;
import com.atlassian.stash.idx.CommitPropertyConfiguration;
import com.atlassian.stash.idx.CommitPropertyConfigurationModuleDescriptor;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluggableCommitPropertyConfiguration
implements CommitPropertyConfiguration,
ChangesetAttributeConfiguration {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluggableCommitPropertyConfiguration(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Collection<String> getPropertiesToPreload(Repository repository) {
        ImmutableSet.Builder properties = ImmutableSet.builder();
        for (CommitPropertyConfiguration config : this.getModules(CommitPropertyConfigurationModuleDescriptor.class)) {
            properties.addAll((Iterable)config.getPropertiesToPreload(repository));
        }
        return properties.build();
    }

    public Collection<String> getAttributesToPreload(Repository repository) {
        ImmutableSet.Builder attributes = ImmutableSet.builder();
        for (ChangesetAttributeConfiguration config : this.getModules(ChangesetAttributeConfigurationModuleDescriptor.class)) {
            attributes.addAll((Iterable)config.getAttributesToPreload(repository));
        }
        return attributes.build();
    }

    private <M, MD extends ModuleDescriptor<M>> Iterable<M> getModules(Class<MD> descriptorClass) {
        return ModuleDescriptorUtils.toModules((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(descriptorClass));
    }
}

