/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.fugue.Option;
import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.hazelcast.serialization.OsgiSafeStreamSerializer;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.auth.trusted.InternalCurrentApplication;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplication;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplicationRestriction;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.concurrent.ExecutorServiceConfiguration;
import com.atlassian.stash.internal.hazelcast.ClusterJoinSocketInterceptor;
import com.atlassian.stash.internal.hazelcast.HighestPlusOneMergePolicy;
import com.atlassian.stash.internal.hazelcast.LicenseStreamSerializer;
import com.atlassian.stash.internal.hazelcast.OptionStreamSerializer;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.LicensedUserCountCache;
import com.atlassian.stash.internal.license.SimpleDualLicense;
import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.InternalRepositoryPushActivity;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.user.InternalPermissionType;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.instance.Capability;
import com.hazelcast.map.merge.LatestUpdateMapMergePolicy;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.spring.context.SpringManagedContext;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class HazelcastConfigFactoryBean
implements FactoryBean<Config> {
    private static final Logger log = LoggerFactory.getLogger(HazelcastConfigFactoryBean.class);
    private final ApplicationContext applicationContext;
    private final int corePoolSize;
    private final LicenseHelper licenseHelper;
    private final OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private final Properties properties;
    @Value(value="${jmx.enabled}")
    private boolean jmxEnabled;
    @Value(value="${hazelcast.group.name}")
    private String groupName;
    @Value(value="${hazelcast.group.password}")
    private String groupPassword;
    @Value(value="${hazelcast.port}")
    private int networkPort;
    @Value(value="${hazelcast.network.aws}")
    private boolean networkAwsEnabled;
    @Value(value="${hazelcast.network.multicast}")
    private boolean networkMulticastEnabled;
    @Value(value="${hazelcast.network.tcpip}")
    private boolean networkTcpIpEnabled;

    @Autowired
    public HazelcastConfigFactoryBean(ApplicationContext applicationContext, ExecutorServiceConfiguration executorServiceConfiguration, LicenseHelper licenseHelper, OsgiSafeStreamSerializer osgiSafeStreamSerializer, @Qualifier(value="applicationProperties") Properties properties) {
        this.applicationContext = applicationContext;
        this.corePoolSize = executorServiceConfiguration.getCorePoolSize();
        this.licenseHelper = licenseHelper;
        this.osgiSafeStreamSerializer = osgiSafeStreamSerializer;
        this.properties = properties;
    }

    public Config getObject() throws Exception {
        SpringManagedContext managedContext = new SpringManagedContext();
        managedContext.setApplicationContext(this.applicationContext);
        Config config = new Config("hazelcast");
        config.setCapabilities(EnumSet.noneOf(Capability.class));
        config.setManagedContext((ManagedContext)managedContext);
        config.setClassLoader(this.getClass().getClassLoader());
        this.configureAttributes(config);
        this.configureGroup(config);
        this.configureJmx(config);
        this.configureEnterprise(config);
        this.configureNetwork(config.getNetworkConfig());
        this.configureSerialization(config.getSerializationConfig());
        this.configureCaches(config);
        this.configureExecutors(config);
        this.configureMaps(config);
        this.configureScheduler(config);
        return config;
    }

    private void configureJmx(Config config) {
        config.setProperty("hazelcast.jmx", Boolean.toString(this.jmxEnabled));
        config.setProperty("hazelcast.jmx.detailed", Boolean.toString(this.jmxEnabled));
    }

    public Class<?> getObjectType() {
        return Config.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private MapConfig boundedCache(Class<?> entityClass) {
        return this.boundedCache(entityClass.getName());
    }

    private MapConfig boundedCache(Class<?> entityClass, String field) {
        String name = entityClass.getName();
        if (StringUtils.isNotBlank((CharSequence)field)) {
            name = name + "." + field;
            if (ReflectionUtils.findField(entityClass, (String)field) == null) {
                throw new IllegalStateException(name + " field does not exist. Please update the cache configuration");
            }
        }
        return this.boundedCache(name);
    }

    private MapConfig boundedCache(String name) {
        return this.boundedCache(name, true);
    }

    private MapConfig boundedCache(String name, boolean nearCache) {
        int timeToIdleSeconds = this.getInt("cache." + name + ".tti", 0);
        int timeToLiveSeconds = this.getInt("cache." + name + ".ttl", 0);
        return this.boundedCache(name, this.getMaxOrFail("cache." + name + ".max"), timeToLiveSeconds, timeToIdleSeconds, nearCache);
    }

    private MapConfig boundedCache(String name, int size, int timeToLive, int timeToIdle, boolean nearCache) {
        size = this.normalizeSize(size);
        MapConfig config = new MapConfig(name).setBackupCount(0).setEvictionPolicy(MapConfig.EvictionPolicy.LFU).setMaxIdleSeconds(Math.max(0, timeToIdle)).setMaxSizeConfig(new MaxSizeConfig(size, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setMinEvictionCheckMillis(0L).setTimeToLiveSeconds(Math.max(0, timeToLive));
        if (nearCache) {
            config.setNearCacheConfig(this.defaultNearCacheConfig().setEvictionPolicy(MapConfig.EvictionPolicy.LFU.name()).setMaxSize(size).setMaxIdleSeconds(Math.max(0, timeToIdle))).setTimeToLiveSeconds(Math.max(0, timeToLive));
        }
        return config;
    }

    private void configureAttributes(Config config) {
        MemberAttributeConfig attributeConfig = new MemberAttributeConfig();
        attributeConfig.setStringAttribute("node.vm.id", UUID.randomUUID().toString());
        config.setMemberAttributeConfig(attributeConfig);
    }

    private void configureCaches(Config config) {
        config.addMapConfig(new MapConfig("org.hibernate.cache.spi.UpdateTimestampsCache").setBackupCount(0).setMergePolicy(LatestUpdateMapMergePolicy.class.getName()).setNearCacheConfig(this.defaultNearCacheConfig()));
        config.addMapConfig(this.boundedCache("query.*", false));
        config.addMapConfig(this.boundedCache("org.hibernate.cache.internal.StandardQueryCache"));
        config.addMapConfig(this.boundedCache("query.groupMemberships"));
        config.addMapConfig(this.boundedCache("query.permissions"));
        config.addMapConfig(this.boundedCache("query.projects"));
        config.addMapConfig(this.boundedCache("query.publicRepositoryCountByProject"));
        config.addMapConfig(this.boundedCache("query.pullRequestCountByUser"));
        config.addMapConfig(this.boundedCache("query.repositoriesByHierarchy"));
        config.addMapConfig(this.boundedCache("query.repositoryBySlug"));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class, "attributes"));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class, "directoryMappings"));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class, "remoteAddresses"));
        config.addMapConfig(this.boundedCache(DirectoryImpl.class));
        config.addMapConfig(this.boundedCache(DirectoryImpl.class, "allowedOperations"));
        config.addMapConfig(this.boundedCache(DirectoryImpl.class, "attributes"));
        config.addMapConfig(this.boundedCache(DirectoryMapping.class));
        config.addMapConfig(this.boundedCache(DirectoryMapping.class, "authorisedGroups"));
        config.addMapConfig(this.boundedCache(DirectoryMapping.class, "allowedOperations"));
        config.addMapConfig(this.boundedCache(GroupMapping.class));
        config.addMapConfig(this.boundedCache(InternalUser.class));
        config.addMapConfig(this.boundedCache(InternalUser.class, "credentialRecords"));
        config.addMapConfig(this.boundedCache(Property.class));
        config.addMapConfig(this.boundedCache(InternalActivity.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalComment.class));
        config.addMapConfig(this.boundedCache(InternalComment.class, "comments"));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussion.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussion.class, "participants"));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussion.class, "watchers"));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussionParticipant.class));
        config.addMapConfig(this.boundedCache(InternalCurrentApplication.class));
        config.addMapConfig(this.boundedCache(InternalDiffCommentAnchor.class));
        config.addMapConfig(this.boundedCache(InternalPermissionType.class));
        config.addMapConfig(this.boundedCache(PluginSetting.class));
        config.addMapConfig(this.boundedCache(InternalProject.class));
        config.addMapConfig(this.boundedCache(InternalPullRequest.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalPullRequest.class, "participants"));
        config.addMapConfig(this.boundedCache(InternalPullRequest.class, "watchers"));
        config.addMapConfig(this.boundedCache(InternalPullRequestParticipant.class));
        config.addMapConfig(this.boundedCache(InternalPullRequestRescopeActivity.class, "commits").setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalRepository.class));
        config.addMapConfig(this.boundedCache(InternalRepositoryHook.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalRepositoryPushActivity.class, "refChanges").setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalStashUser.class));
        config.addMapConfig(this.boundedCache(InternalTask.class));
        config.addMapConfig(this.boundedCache(InternalTrustedApplication.class));
        config.addMapConfig(this.boundedCache(InternalTrustedApplication.class, "restrictions"));
        config.addMapConfig(this.boundedCache(InternalTrustedApplicationRestriction.class));
        config.addMapConfig(this.boundedCache(InternalUserSettings.class));
        config.addMapConfig(this.boundedCache(InternalWatcher.class));
        config.addMapConfig(new MapConfig("atlassian-cache.*").setBackupCount(0).setNearCacheConfig(this.defaultNearCacheConfig()));
        config.addMapConfig(this.boundedCache("atlassian-cache.Cache." + ApplicationPropertiesService.class.getName(), 0, 0, 0, true));
        config.addMapConfig(this.boundedCache("atlassian-cache.CacheReference." + LicenseService.class.getName() + ".StashLicense", 0, 0, 0, true));
        config.addMapConfig(this.boundedCache(LicensedUserCountCache.class));
        config.addMapConfig(this.boundedCache(RepositoryMetadataService.class));
        config.addMapConfig(this.boundedCache("cache.permissionGraph.defaultPermissions", 0, 0, 0, true));
        config.addMapConfig(this.boundedCache("cache.permissionGraph.groupPermissions", this.getMaxOrFail("permissions.cache.groups.max"), 0, 0, true));
        config.addMapConfig(this.boundedCache("cache.permissionGraph.userPermissions", this.getMaxOrFail("permissions.cache.users.max"), 0, 0, true));
        config.addMapConfig(new MapConfig("versiontracker.*").setBackupCount(1).setMergePolicy(HighestPlusOneMergePolicy.class.getName()));
    }

    private void configureEnterprise(Config config) {
        String managementCenterUrl;
        String license = this.properties.getProperty("hazelcast.enterprise.license");
        if (StringUtils.isNotBlank((CharSequence)license)) {
            config.setLicenseKey(license);
        }
        if (StringUtils.isNotBlank((CharSequence)(managementCenterUrl = this.properties.getProperty("hazelcast.managementcenter.url")))) {
            config.setManagementCenterConfig(new ManagementCenterConfig().setEnabled(true).setUrl(managementCenterUrl));
        }
    }

    private void configureExecutors(Config config) {
        config.addExecutorConfig(new ExecutorConfig("stash.core", this.corePoolSize));
    }

    private void configureGroup(Config config) {
        config.setGroupConfig(new GroupConfig(this.groupName, this.groupPassword));
        config.setProperty("hazelcast.graceful.shutdown.max.wait", this.properties.getProperty("hazelcast.graceful.shutdown.max.wait"));
        config.setProperty("hazelcast.health.monitoring.level", this.properties.getProperty("hazelcast.health.monitoring.level"));
        config.setProperty("hazelcast.health.monitoring.delay.seconds", this.properties.getProperty("hazelcast.health.monitoring.delay"));
        config.setProperty("hazelcast.max.no.heartbeat.seconds", this.properties.getProperty("hazelcast.max.no.heartbeat"));
        config.setProperty("hazelcast.operation.call.timeout.millis", this.properties.getProperty("hazelcast.operation.call.timeout"));
        config.setProperty("hazelcast.partition.backup.sync.interval", Long.toString(TimeUnit.MINUTES.toSeconds(this.getIntOrFail("hazelcast.backup.sync.interval"))));
        config.setProperty("hazelcast.response.thread.count", this.properties.getProperty("hazelcast.response.thread.count"));
        config.setProperty("hazelcast.version.check.enabled", this.properties.getProperty("hazelcast.version.check.enabled"));
    }

    private void configureMaps(Config config) {
        config.addMapConfig(new MapConfig("default").setBackupCount(1));
        config.addMapConfig(new MapConfig(HttpSession.class.getName()).setAsyncBackupCount(1).setBackupCount(0).setNearCacheConfig(this.defaultNearCacheConfig()));
    }

    private void configureNetwork(NetworkConfig config) {
        if (this.networkMulticastEnabled && this.networkTcpIpEnabled) {
            log.warn("Both TCP/IP and Multicast have been enabled for Hazelcast node discovery. Setting to default TCP/IP");
            this.networkMulticastEnabled = false;
        }
        boolean clusteringEnabled = this.licenseHelper.isClusteringEnabled(false);
        JoinConfig joinConfig = config.getJoin();
        AwsConfig awsConfig = joinConfig.getAwsConfig().setEnabled(clusteringEnabled && this.networkAwsEnabled);
        if (this.networkAwsEnabled) {
            String awsAccessKey = this.properties.getProperty("hazelcast.network.aws.access.key");
            String awsSecretKey = this.properties.getProperty("hazelcast.network.aws.secret.key");
            String awsRegion = this.properties.getProperty("hazelcast.network.aws.region");
            String awsHostHeader = this.properties.getProperty("hazelcast.network.aws.host.header");
            String awsSecurityGroupName = this.properties.getProperty("hazelcast.network.aws.security.group.name");
            String awsTagKey = this.properties.getProperty("hazelcast.network.aws.tag.key");
            String awsTagValue = this.properties.getProperty("hazelcast.network.aws.tag.value");
            String awsConnectionTimeoutSecondsStr = this.properties.getProperty("hazelcast.network.aws.connection.timeout.seconds", "-1");
            int awsConnectionTimeoutSeconds = -1;
            try {
                awsConnectionTimeoutSeconds = Integer.parseInt(awsConnectionTimeoutSecondsStr);
            }
            catch (NumberFormatException e) {
                log.warn("Can't parse property \"hazelcast.network.aws.connection.timeout.seconds\" value \"{}\", ignoring", (Object)awsConnectionTimeoutSecondsStr);
            }
            awsConfig.setAccessKey(awsAccessKey);
            awsConfig.setSecretKey(awsSecretKey);
            if (StringUtils.isNotEmpty((CharSequence)awsRegion)) {
                awsConfig.setRegion(awsRegion);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsHostHeader)) {
                awsConfig.setHostHeader(awsHostHeader);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsSecurityGroupName)) {
                awsConfig.setSecurityGroupName(awsSecurityGroupName);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsTagKey)) {
                awsConfig.setTagKey(awsTagKey);
                awsConfig.setTagValue(awsTagValue);
            }
            if (awsConnectionTimeoutSeconds >= 0) {
                awsConfig.setConnectionTimeoutSeconds(awsConnectionTimeoutSeconds);
            }
        }
        MulticastConfig multicastConfig = joinConfig.getMulticastConfig();
        multicastConfig.setEnabled(clusteringEnabled && this.networkMulticastEnabled);
        multicastConfig.setMulticastPort(this.networkPort);
        TcpIpConfig tcpIp = joinConfig.getTcpIpConfig().setEnabled(clusteringEnabled && this.networkTcpIpEnabled);
        String tcpIpMembers = this.properties.getProperty("hazelcast.network.tcpip.members");
        if (StringUtils.isNotBlank((CharSequence)tcpIpMembers)) {
            tcpIp.addMember(tcpIpMembers);
        }
        config.setPort(this.networkPort);
        if (clusteringEnabled) {
            SocketInterceptorConfig interceptorConfig = new SocketInterceptorConfig();
            interceptorConfig.setClassName(ClusterJoinSocketInterceptor.class.getName());
            interceptorConfig.setEnabled(true);
            config.setSocketInterceptorConfig(interceptorConfig);
        }
    }

    private void configureScheduler(Config config) {
        config.addMapConfig(new MapConfig("quartz.jobStore.calendars"));
        config.addMapConfig(new MapConfig("quartz.jobStore.jobs"));
        config.addMapConfig(new MapConfig("quartz.jobStore.triggers").setMapIndexConfigs((List)ImmutableList.of((Object)new MapIndexConfig("jobGroup", false), (Object)new MapIndexConfig("jobName", false), (Object)new MapIndexConfig("nextFireTime", false), (Object)new MapIndexConfig("state", false))));
    }

    private void configureSerialization(SerializationConfig config) {
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)this.osgiSafeStreamSerializer).setTypeClass(OsgiSafe.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new LicenseStreamSerializer(this.licenseHelper)).setTypeClass(SimpleDualLicense.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new OptionStreamSerializer()).setTypeClass(Option.class));
    }

    private NearCacheConfig defaultNearCacheConfig() {
        return new NearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT).setCacheLocalEntries(true);
    }

    private int getInt(String propertyName, int defaultValue) {
        String maxSize = this.properties.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)maxSize)) {
            return defaultValue;
        }
        return Integer.parseInt(maxSize);
    }

    private int getIntOrFail(String propertyName) {
        String maxSize = this.properties.getProperty(propertyName);
        Preconditions.checkState((!StringUtils.isBlank((CharSequence)maxSize) ? 1 : 0) != 0, (String)"Property '{}' is undefined", (Object[])new Object[]{propertyName});
        return Integer.parseInt(maxSize);
    }

    private int getMaxOrFail(String propertyName) {
        int configured = this.getIntOrFail(propertyName);
        int normalized = this.normalizeSize(configured);
        if (configured != 0 && configured != normalized) {
            log.warn("Ignoring \"{}={}\"; values less than 500, except 0, are not valid", (Object)propertyName, (Object)configured);
        }
        return normalized;
    }

    private int normalizeSize(int size) {
        if (size <= 0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(size, 500);
    }
}

