/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.stash.internal.cluster.ClusterJoinManager;
import com.atlassian.stash.internal.cluster.ClusterJoinMode;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ObjectDataInputStream;
import com.hazelcast.nio.serialization.ObjectDataOutputStream;
import com.hazelcast.spring.context.SpringAware;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@SpringAware
public class ClusterJoinSocketInterceptor
implements MemberSocketInterceptor,
HazelcastInstanceAware {
    private ClusterJoinManager clusterJoinManager;
    private HazelcastInstanceImpl hazelcast;

    public void init(Properties properties) {
    }

    public void onAccept(Socket socket) throws IOException {
        this.clusterJoinManager.accept(new SocketClusterJoinRequest(socket, this.hazelcast, ClusterJoinMode.ACCEPT));
    }

    public void onConnect(Socket socket) throws IOException {
        this.clusterJoinManager.connect(new SocketClusterJoinRequest(socket, this.hazelcast, ClusterJoinMode.CONNECT));
    }

    @Autowired
    public void setClusterJoinManager(ClusterJoinManager clusterJoinManager) {
        this.clusterJoinManager = clusterJoinManager;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcast) {
        this.hazelcast = (HazelcastInstanceImpl)hazelcast;
    }

    static class SocketClusterJoinRequest
    implements ClusterJoinRequest {
        private final ClusterJoinMode joinMode;
        private final HazelcastInstanceImpl hazelcast;
        private final ObjectDataInputStream in;
        private final ObjectDataOutputStream out;

        SocketClusterJoinRequest(Socket socket, HazelcastInstanceImpl hazelcast, ClusterJoinMode joinMode) throws IOException {
            this.joinMode = joinMode;
            this.hazelcast = hazelcast;
            this.in = hazelcast.getSerializationService().createObjectDataInputStream(socket.getInputStream());
            this.out = hazelcast.getSerializationService().createObjectDataOutputStream(socket.getOutputStream());
        }

        @Override
        @Nonnull
        public HazelcastInstance getHazelcast() {
            return this.hazelcast;
        }

        @Override
        @Nonnull
        public ClusterJoinMode getJoinMode() {
            return this.joinMode;
        }

        @Override
        @Nonnull
        public ObjectDataInput in() {
            return this.in;
        }

        @Override
        @Nonnull
        public ObjectDataOutput out() {
            return this.out;
        }
    }
}

