/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.utils.process.IOUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MimeTypeMappingConfiguration
implements FileNameMap {
    private static final String BINARY_TYPES_RESOURCE = "binary-mime.types";
    private static final String TEXT_TYPES_RESOURCE = "text-mime.types";
    private static final Logger log = LoggerFactory.getLogger(MimeTypeMappingConfiguration.class);
    private final Map<String, String> mimeMap = new HashMap<String, String>();
    private final Set<String> textTypes = new HashSet<String>();
    private final Set<String> binaryTypes = new HashSet<String>();
    private final ApplicationSettings applicationSettings;
    private FileNameMap fallbackMap;

    @Autowired
    public MimeTypeMappingConfiguration(ApplicationSettings applicationSettings) {
        this.applicationSettings = applicationSettings;
        this.fallbackMap = URLConnection.getFileNameMap();
    }

    @PostConstruct
    public void init() {
        this.loadInternalConfig();
        this.loadConfig(this.applicationSettings.getConfigDir());
        URLConnection.setFileNameMap(this);
    }

    private void loadInternalConfig() {
        ClassLoader loader = MimeTypeMappingConfiguration.class.getClassLoader();
        this.loadMimeMap(loader.getResourceAsStream(BINARY_TYPES_RESOURCE), false, BINARY_TYPES_RESOURCE);
        this.loadMimeMap(loader.getResourceAsStream(TEXT_TYPES_RESOURCE), true, TEXT_TYPES_RESOURCE);
    }

    private void loadConfig(File ... directories) {
        for (File directory : directories) {
            this.loadMimeMap(new File(directory, BINARY_TYPES_RESOURCE), false);
            this.loadMimeMap(new File(directory, TEXT_TYPES_RESOURCE), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimeMap(File mapFile, boolean textMap) {
        if (!mapFile.isFile()) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(mapFile);
            this.loadMimeMap(in, textMap, mapFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            try {
                log.warn("Error reading mime type mapping from " + mapFile, (Throwable)fnfe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)in);
        }
        IOUtils.closeQuietly((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimeMap(InputStream mapStream, boolean textMap, String sourceName) {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(mapStream));
            while ((line = in.readLine()) != null) {
                String mimeType;
                if ((line = line.trim()).startsWith("#") || line.length() == 0 || (mimeType = this.parseLine(line)) == null) continue;
                if (textMap) {
                    this.addTextMimeType(mimeType);
                    continue;
                }
                this.addBinaryMimeType(mimeType);
            }
        }
        catch (IOException e) {
            try {
                log.warn("Error reading mime type mapping from " + sourceName, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)in);
        }
        IOUtils.closeQuietly((Closeable)in);
    }

    private String parseLine(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        String mimetype = null;
        if (tok.hasMoreTokens()) {
            mimetype = tok.nextToken();
            while (tok.hasMoreTokens()) {
                String ext = tok.nextToken();
                this.addExtensionMapping(mimetype, ext);
            }
        } else {
            log.warn("not a valid line in mime type file: {}", (Object)line);
        }
        return mimetype;
    }

    @VisibleForTesting
    void addTextMimeType(String mimeType) {
        this.textTypes.add(mimeType);
    }

    @VisibleForTesting
    void addBinaryMimeType(String mimeType) {
        this.binaryTypes.add(mimeType);
    }

    @VisibleForTesting
    void addExtensionMapping(String mimeType, String extension) {
        this.mimeMap.put(extension, mimeType);
    }

    @VisibleForTesting
    boolean isTextMimeType(String mimeType) {
        return mimeType != null && (mimeType.startsWith("text/") || this.textTypes.contains(mimeType));
    }

    @VisibleForTesting
    boolean isBinaryMimeType(String mimeType) {
        return mimeType != null && !mimeType.startsWith("text/") && this.binaryTypes.contains(mimeType);
    }

    @Override
    public String getContentTypeFor(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (fileName.length() == idx + 1) {
            return null;
        }
        String ext = fileName.substring(idx + 1);
        if (this.mimeMap.containsKey(ext)) {
            return this.mimeMap.get(ext);
        }
        if (this.fallbackMap != null) {
            return this.fallbackMap.getContentTypeFor(fileName);
        }
        return null;
    }
}

