/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.property.PropertySupport;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractProviderContext<E extends PropertySupport> {
    protected final Map<E, AttributeMap.Builder> attributes;
    protected final Iterable<E> attributeHolders;
    protected final Map<E, PropertyMap.Builder> properties;

    protected AbstractProviderContext(Iterable<? extends E> attributeHolders) {
        this.attributeHolders = attributeHolders;
        this.attributes = new HashMap<E, AttributeMap.Builder>();
        this.properties = new HashMap<E, PropertyMap.Builder>();
    }

    public Iterator<E> iterator() {
        return this.attributeHolders.iterator();
    }

    public void addAttribute(@Nonnull E attributeHolder, @Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull(attributeHolder);
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        AttributeMap.Builder builder = this.attributes.get(attributeHolder);
        if (builder == null) {
            builder = new AttributeMap.Builder();
            this.attributes.put(attributeHolder, builder);
        }
        builder.add(key, new String[]{value});
    }

    @Nonnull
    public AttributeMap getAttributesFor(@Nonnull E attributeHolder) {
        AttributeMap.Builder builder = this.attributes.get(attributeHolder);
        return builder == null ? AttributeMap.EMPTY : builder.build();
    }

    @Nonnull
    public PropertyMap getPropertiesFor(@Nonnull E entity) {
        PropertyMap.Builder builder = this.properties.get(entity);
        return builder == null ? PropertyMap.EMPTY : builder.build();
    }

    public void setProperty(@Nonnull E entity, @Nonnull String key, @Nonnull Object value) {
        Preconditions.checkNotNull(entity, (Object)"entity");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        PropertyMap.Builder builder = this.properties.get(entity);
        if (builder == null) {
            builder = new PropertyMap.Builder();
            this.properties.put(entity, builder);
        }
        builder.property(key, value);
    }
}

