/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.concurrent.BucketedExecutorSettings;
import com.atlassian.stash.internal.concurrent.BucketedExecutorFactory;
import com.atlassian.stash.internal.concurrent.ConfigurableThreadFactory;
import com.atlassian.stash.internal.concurrent.HazelcastBucketedExecutor;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.hazelcast.core.HazelcastInstance;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;

public class HazelcastBucketedExecutorFactory
implements BucketedExecutorFactory {
    private final ClassLoader classLoader;
    private final HazelcastInstance hazelcast;
    private final ThreadGroup threadGroup;

    public HazelcastBucketedExecutorFactory(ClassLoader classLoader, HazelcastInstance hazelcast, ThreadGroup threadGroup) {
        this.classLoader = classLoader;
        this.hazelcast = hazelcast;
        this.threadGroup = threadGroup;
    }

    @Override
    @Nonnull
    public <T extends Serializable> InternalBucketedExecutor<T> create(@Nonnull String name, @Nonnull BucketedExecutorSettings<T> settings) {
        ConfigurableThreadFactory threadFactory = new ConfigurableThreadFactory();
        threadFactory.setClassLoader(this.classLoader);
        threadFactory.setDaemon(true);
        threadFactory.setThreadGroup(this.threadGroup);
        threadFactory.setThreadNamePrefix(name);
        return new HazelcastBucketedExecutor<T>(name, settings, this.hazelcast, (ThreadFactory)threadFactory);
    }
}

