/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HazelcastDataUtils {
    private HazelcastDataUtils() {
    }

    public static List<String> readList(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        ArrayList<String> list = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            list.add(in.readUTF());
        }
        return list;
    }

    public static Map<String, Serializable> readMap(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(length);
        for (int i = 0; i < length; ++i) {
            map.put(in.readUTF(), (Serializable)in.readObject());
        }
        return map;
    }

    public static void writeList(ObjectDataOutput out, List<String> list) throws IOException {
        out.writeInt(list.size());
        for (String message : list) {
            out.writeUTF(message);
        }
    }

    public static void writeMap(ObjectDataOutput out, Map<String, Serializable> map) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<String, Serializable> entry : map.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject((Object)entry.getValue());
        }
    }
}

