/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.CommonValidations;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.user.PermissionService;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="permissionPredicateFactory")
public class PermissionPredicateFactoryImpl
implements PermissionPredicateFactory {
    private final PermissionService permissionService;
    private final Predicate<Project> projectAccessiblePredicate;
    private final Predicate<Repository> repositoryAccessiblePredicate;

    @Autowired
    public PermissionPredicateFactoryImpl(PermissionService permissionService) {
        this.permissionService = permissionService;
        this.projectAccessiblePredicate = new Predicate<Project>(){

            public boolean apply(Project project) {
                CommonValidations.validateProject(project);
                return PermissionPredicateFactoryImpl.this.permissionService.isProjectAccessible(project);
            }
        };
        this.repositoryAccessiblePredicate = new Predicate<Repository>(){

            public boolean apply(Repository repository) {
                CommonValidations.validateRepository(repository);
                return PermissionPredicateFactoryImpl.this.permissionService.isRepositoryAccessible(repository);
            }
        };
    }

    @Nonnull
    public Predicate<Project> createProjectAccessiblePredicate() {
        return this.projectAccessiblePredicate;
    }

    @Nonnull
    public Predicate<Project> createProjectPermissionPredicate(final @Nonnull Permission permission) {
        CommonValidations.validateProjectPermission(permission);
        return new Predicate<Project>(){

            public boolean apply(Project project) {
                CommonValidations.validateProject(project);
                return PermissionPredicateFactoryImpl.this.permissionService.hasProjectPermission(project, permission);
            }
        };
    }

    @Nonnull
    public Predicate<PullRequest> createPullRequestPermissionPredicate(@Nonnull Permission permission) {
        final Predicate<Repository> requestedRepositoryPredicate = this.createRepositoryPermissionPredicate(permission);
        return new Predicate<PullRequest>(){

            public boolean apply(PullRequest pullRequest) {
                return requestedRepositoryPredicate.apply((Object)pullRequest.getToRef().getRepository());
            }
        };
    }

    @Nonnull
    public Predicate<Repository> createRepositoryAccessiblePredicate() {
        return this.repositoryAccessiblePredicate;
    }

    @Nonnull
    public Predicate<Repository> createRepositoryPermissionPredicate(final @Nonnull Permission permission) {
        CommonValidations.validateRepositoryPermission(permission);
        return new Predicate<Repository>(){

            public boolean apply(Repository repository) {
                CommonValidations.validateRepository(repository);
                return PermissionPredicateFactoryImpl.this.permissionService.hasRepositoryPermission(repository, permission);
            }
        };
    }
}

