/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.request.RequestEndedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.user.DefaultEscalatedSecurityContext;
import com.atlassian.stash.user.EscalatedSecurityContext;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PreAuthenticationFailedException;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Operation;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=SecurityService.class)
@NotProfiled
@Service(value="securityService")
public class DefaultSecurityService
implements SecurityService {
    private final StashAuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final UserService userService;

    @Autowired
    public DefaultSecurityService(StashAuthenticationContext authenticationContext, I18nService i18nService, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.userService = userService;
    }

    @Nonnull
    public EscalatedSecurityContext anonymously(@Nonnull String reason) {
        return new DefaultEscalatedSecurityContext((String)Preconditions.checkNotNull((Object)reason, (Object)"reason"), null);
    }

    @Nonnull
    public EscalatedSecurityContext impersonating(@Nonnull StashUser user, @Nonnull String reason) {
        return new DefaultEscalatedSecurityContext((String)Preconditions.checkNotNull((Object)reason, (Object)"reason"), (StashUser)Preconditions.checkNotNull((Object)user, (Object)"user"));
    }

    public <T, E extends Throwable> T doAnonymously(@Nonnull String reason, @Nonnull Operation<T, E> operation) throws E {
        return (T)this.anonymously(reason).call(operation);
    }

    public <T, E extends Throwable> T doAsUser(@Nonnull String reason, @Nonnull String username, @Nonnull Operation<T, E> operation) throws E {
        StashUser runAsUser = this.userService.getUserByName((String)Preconditions.checkNotNull((Object)username, (Object)"username"));
        if (runAsUser == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.user.preauthfail", new Object[]{username});
            throw new PreAuthenticationFailedException(message);
        }
        return (T)this.impersonating(runAsUser, reason).call(operation);
    }

    public <T, E extends Throwable> T doWithPermission(@Nonnull String reason, @Nonnull Permission permission, @Nonnull Operation<T, E> operation) throws E {
        return (T)this.withPermission(permission, reason).call(operation);
    }

    public <T, E extends Throwable> T doWithPermissions(@Nonnull String reason, @Nonnull Collection<Permission> permissions, @Nonnull Operation<T, E> operation) throws E {
        return (T)this.withPermissions(EnumSet.copyOf(permissions), reason).call(operation);
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        SecurityContextHolder.clearContext();
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission, @Nonnull String reason) {
        return new DefaultEscalatedSecurityContext((String)Preconditions.checkNotNull((Object)reason, (Object)"reason"), this.authenticationContext.getCurrentUser()).withPermission((Permission)Preconditions.checkNotNull((Object)permission, (Object)"permission"));
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission, @Nonnull Object resource, @Nonnull String reason) {
        return new DefaultEscalatedSecurityContext((String)Preconditions.checkNotNull((Object)reason, (Object)"reason"), this.authenticationContext.getCurrentUser()).withPermission(resource, (Permission)Preconditions.checkNotNull((Object)permission, (Object)"permission"));
    }

    @Nonnull
    public EscalatedSecurityContext withPermissions(@Nonnull Set<Permission> permissions, @Nonnull String reason) {
        return new DefaultEscalatedSecurityContext((String)Preconditions.checkNotNull((Object)reason, (Object)"reason"), this.authenticationContext.getCurrentUser()).withPermissions((Set)Preconditions.checkNotNull(permissions, (Object)"permissions"));
    }
}

